declare type ConnectionEventType = 'disconnect' | 'newVideoProducer' | 'videoProducerGone';
declare type PublishStatus = 'connecting' | 'connected' | 'failed' | 'updateStream';
export declare class Sender {
    private socket;
    private device;
    private publishTransport;
    private publishVideoStream;
    private publishAudioStream;
    private clientUUID;
    private streamUUID;
    private authToken;
    private sourceConstraints;
    private webCamProducer;
    private micProducer;
    private serverDomain;
    private serverPort;
    constructor(serverDomain: string, serverPort: number);
    connect(callback: (eventType: ConnectionEventType) => void): Promise<unknown>;
    disconnect(callback: () => void): Promise<void>;
    private loadDevice;
    checkResources(streamUUID: string, authToken: string): Promise<boolean>;
    publish(streamUUID: string, authToken: string, isButtonClicked: boolean, isAudioOnly: boolean, publishCallback: (status: PublishStatus, audioStream: MediaStream, videoStream: MediaStream) => void): Promise<void>;
    stopPublish(): Promise<void>;
    private closeWebCam;
    private removeData;
    private getVideoUserMedia;
    private getAudioUserMedia;
    private createUUID;
}
export {};
