export declare function throttledMethod(delay: number): (target: any, propertyKey: string, descriptor: PropertyDescriptor) => void;
export declare function loadSensitiveThrottling(minDelay: number, executionTimeDelayFactor: number, maxDelay?: number): (target: any, propertyKey: string, descriptor: PropertyDescriptor) => void;
/**
 *  Returns a function, whose execution is limited with a certain delay.
 *  When the returned function gets called multiple times within a delay cycle, only the last invocation will be executed.
 *
 *  @see debounce
 */
export declare function throttle(func: (...args: any[]) => any, delay: number): ((...args: any[]) => void);
/**
 *  Returns a function, whose execution is dynamically throttled, depending on the actual load. The load is determined by the time it takes from the beginning of the execution
 *  to a queued task.
 *
 * @param func                      function to be throttled
 * @param minDelay                  minimum throttling delay
 * @param executionTimeDelayFactor  the factor to multiply with the actual execution time + queue task execution delay
 * @param maxDelay                  maximum throttling delay
 */
export declare function loadSensitiveThrottle(func: (...args: any[]) => any, minDelay: number, executionTimeDelayFactor: number, maxDelay?: number): ((...args: any[]) => void);
