import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { UiTemplateConfig } from "../../generated/UiTemplateConfig";
import { UiButton_ClickedEvent, UiButton_DropDownOpenedEvent, UiButtonCommandHandler, UiButtonConfig, UiButtonEventSource } from "../../generated/UiButtonConfig";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiComponent } from "../UiComponent";
import { AbstractUiComponent } from "../AbstractUiComponent";
export declare class UiButton extends AbstractUiComponent<UiButtonConfig> implements UiButtonEventSource, UiButtonCommandHandler {
    readonly onClicked: TeamAppsEvent<UiButton_ClickedEvent>;
    readonly onDropDownOpened: TeamAppsEvent<UiButton_DropDownOpenedEvent>;
    private template;
    private templateRecord;
    private $main;
    private _dropDown;
    private dropDownComponent;
    private minDropDownWidth;
    private minDropDownHeight;
    private openDropDownIfNotSet;
    constructor(config: UiButtonConfig, context: TeamAppsUiContext);
    setDropDownSize(minDropDownWidth: number, minDropDownHeight: number): void;
    setDropDownComponent(component: UiComponent): void;
    private closeDropDown;
    private get dropDown();
    setOpenDropDownIfNotSet(openDropDownIfNotSet: boolean): void;
    doGetMainElement(): HTMLElement;
    setTemplate(template: UiTemplateConfig, templateRecord: any): void;
    setTemplateRecord(data: any): void;
}
