import { EventObjectInput, EventSourceExtendedInput, EventSourceFunction } from "fullcalendar/src/types/input-types";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiCalendar_DataNeededEvent, UiCalendar_DayClickedEvent, UiCalendar_EventClickedEvent, UiCalendar_EventMovedEvent, UiCalendar_ViewChangedEvent, UiCalendarCommandHandler, UiCalendarConfig, UiCalendarEventSource } from "../generated/UiCalendarConfig";
import { UiComponent } from "./UiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiCalendarViewMode } from "../generated/UiCalendarViewMode";
import { UiCalendarEventClientRecordConfig } from "../generated/UiCalendarEventClientRecordConfig";
import { UiTemplateConfig } from "../generated/UiTemplateConfig";
export declare class UiCalendar extends UiComponent<UiCalendarConfig> implements UiCalendarCommandHandler, UiCalendarEventSource {
    readonly onEventClicked: TeamAppsEvent<UiCalendar_EventClickedEvent>;
    readonly onEventMoved: TeamAppsEvent<UiCalendar_EventMovedEvent>;
    readonly onDayClicked: TeamAppsEvent<UiCalendar_DayClickedEvent>;
    readonly onViewChanged: TeamAppsEvent<UiCalendar_ViewChangedEvent>;
    readonly onDataNeeded: TeamAppsEvent<UiCalendar_DataNeededEvent>;
    private $main;
    private $fullCalendar;
    private eventSource;
    private templateRenderers;
    constructor(config: UiCalendarConfig, context: TeamAppsUiContext);
    private renderEventObject;
    registerTemplate(id: string, template: UiTemplateConfig): void;
    protected onAttachedToDom(): void;
    private convertToFullCalendarEvent;
    setViewMode(viewMode: UiCalendarViewMode): void;
    setDisplayedDate(date: number): void;
    addEvent(theEvent: any): void;
    removeEvent(eventId: any): void;
    setCalendarData(events: UiCalendarEventClientRecordConfig[]): void;
    clearCalendar(): void;
    onResize(): void;
    getMainDomElement(): JQuery;
    destroy(): void;
}
interface EventObject extends EventObjectInput {
    templateId: string;
    data: any;
}
export declare class UiCalendarFullCalendarEventSource implements EventSourceExtendedInput {
    private teamappsUiContext;
    private componentId;
    readonly onViewChanged: TeamAppsEvent<UiCalendar_ViewChangedEvent>;
    readonly onDataNeeded: TeamAppsEvent<UiCalendar_DataNeededEvent>;
    private logger;
    private intervalManager;
    private cachedEvents;
    events: EventSourceFunction;
    constructor(teamappsUiContext: TeamAppsUiContext, componentId: string);
    private createEventsFunction;
    private removeTimeZoneOffsetFromAmbiguouslyTimedMoment;
    addEvents(start: number, end: number, newEvents: EventObject[]): void;
    addEvent(newEvent: EventObject): void;
    removeEvent(eventId: number | string): void;
    getEvent(eventId: number | string): any;
    removeAllEvents(): void;
}
export {};
