import { TeamAppsUiContext } from "./TeamAppsUiContext";
import * as log from "loglevel";
import { UiComponentCommandHandler, UiComponentConfig } from "../generated/UiComponentConfig";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
export declare abstract class UiComponent<C extends UiComponentConfig = UiComponentConfig> implements UiComponentCommandHandler {
    protected _config: C;
    protected _context: TeamAppsUiContext;
    protected readonly logger: log.Logger;
    readonly onVisibilityChanged: TeamAppsEvent<boolean>;
    readonly onResized: TeamAppsEvent<{
        width: number;
        height: number;
    }>;
    readonly onAttachedToDomChanged: TeamAppsEvent<boolean>;
    private _attachedToDom;
    private width;
    private height;
    private firstReLayout;
    private visible;
    constructor(_config: C, _context: TeamAppsUiContext);
    getId(): string;
    getTeamAppsType(): string;
    attachedToDom: boolean;
    /**
     * This method should get called from a container component when the available size for a child changes.
     */
    reLayout(force?: boolean): void;
    /**
     * This method gets called whenever the available size for this component changes.
     */
    onResize(): void;
    /**
     * This method is called when the component gets destroyed.
     * It should be used to release any resources the component holds. This can be:
     *   - additional DOM elements that are not children of the component's main DOM element, e.g. attached to the document's body.
     *   - other resources that are not released just by removing the component's main DOM element
     */
    destroy(): void;
    /**
     * @return The main DOM element of this component.
     * This method is used by the main TeamApps UI mechanism to get the element and attach it to the DOM.
     */
    abstract getMainDomElement(): JQuery;
    /**
     * Override this method to execute code that cannot be executed before the field is attached to the DOM.
     *
     * Example 1:
     *   An HTML/Flash video player with autoplay = true will not be able to play until it is attached to the DOM.
     *   So the code for starting the video will need to be executed in this (overwritten) method.
     * Example 2:
     *   UiTable uses slickgrid. slickgrid can only initialize correctly when attached to the DOM.
     *
     * Components containing other components should set attachedToDom on their child components.
     * This will in turn invoke this method on the children, so the call propagates recursively.
     *
     * Example:
     *   A component with child components will call "child.attachedToDom = true" on its children.
     */
    protected onAttachedToDom(): void;
    getWidth(): number;
    getHeight(): number;
    isVisible(): boolean;
    setVisible(visible?: boolean, fireEvent?: boolean): void;
    setStyle(selector: string, style: {
        [property: string]: string;
    }): void;
}
