import { UiField } from "./UiField";
import { UiMultiLineTextFieldConfig, UiMultiLineTextFieldCommandHandler, UiMultiLineTextFieldEventSource } from "../../generated/UiMultiLineTextFieldConfig";
import { UiFieldEditingMode } from "../../generated/UiFieldEditingMode";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiTextInputHandlingField_SpecialKeyPressedEvent, UiTextInputHandlingField_TextInputEvent } from "../../generated/UiTextInputHandlingFieldConfig";
export declare class UiMultiLineTextField extends UiField<UiMultiLineTextFieldConfig, string> implements UiMultiLineTextFieldEventSource, UiMultiLineTextFieldCommandHandler {
    readonly onTextInput: TeamAppsEvent<UiTextInputHandlingField_TextInputEvent>;
    readonly onSpecialKeyPressed: TeamAppsEvent<UiTextInputHandlingField_SpecialKeyPressedEvent>;
    private $wrapper;
    private $field;
    private $clearButton;
    private showClearButton;
    private minHeight;
    private maxHeight;
    protected initialize(config: UiMultiLineTextFieldConfig, context: TeamAppsUiContext): void;
    private fireTextInput;
    isValidData(v: string): boolean;
    private updateTextareaHeight;
    setMaxCharacters(maxCharacters: number): void;
    setShowClearButton(showClearButton: boolean): void;
    private updateClearButton;
    setEmptyText(emptyText: string): void;
    getMainInnerDomElement(): JQuery;
    getFocusableElement(): JQuery;
    protected displayCommittedValue(): void;
    getTransientValue(): string;
    focus(): void;
    append(s: string, scrollToBottom: boolean): void;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    getReadOnlyHtml(value: string, availableWidth: number): string;
    getDefaultValue(): string;
    valuesChanged(v1: string, v2: string): boolean;
    setMinHeight(minHeight: number): void;
    setMaxHeight(maxHeight: number): void;
}
