import { DebounceMode } from "./debounce";
export declare type TeamAppsEventListener<EO> = (eventObject?: EO, emitter?: any) => void;
/**
 * @param EO the event object type
 */
export declare class TeamAppsEvent<EO> {
    private eventSource;
    private debounceDelay;
    private debounceMode;
    private listeners;
    private previousEventObject;
    constructor(eventSource: any, debounceDelay?: number, debounceMode?: DebounceMode);
    addListener(fn: TeamAppsEventListener<EO>, allowDuplicates?: boolean): void;
    removeListener(fn: TeamAppsEventListener<EO>): void;
    private _fire;
    fire: (eventObject: EO) => void;
    fireIfChanged(eventObject: EO): void;
    getListeners(): TeamAppsEventListener<EO>[];
}
