export declare class Receiver {
    private socket;
    private device;
    private subscribeTransport;
    private subscribeStreamVideo;
    private subscribeStreamAudio;
    private consumerAudio;
    private consumerVideo;
    private clientUUID;
    private streamUUID;
    private sourceConstraints;
    private serverDomain;
    private serverPort;
    constructor(serverDomain: string, serverPort: number);
    connect(callback: (status: string) => void): Promise<void>;
    disconnect(callback: () => void): Promise<void>;
    private loadDevice;
    checkResources(streamUUID: string): Promise<boolean>;
    subscribe(streamUUID: string, isAudioOnly: boolean, isButtonClicked: boolean, videoProducerAvailable: boolean, subscribeCallback: (status: string, streamAudio: any, streamVideo: any) => void): Promise<void>;
    unsubscribe(): Promise<void>;
    private consume;
    private removeData;
    private createUUID;
}
