import * as log from "loglevel";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { UiField_ValueChangedEvent, UiFieldCommandHandler, UiFieldConfig, UiFieldEventSource } from "../../generated/UiFieldConfig";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiFieldEditingMode } from "../../generated/UiFieldEditingMode";
import { UiComponent } from "../UiComponent";
import { UiFieldMessageConfig } from "../../generated/UiFieldMessageConfig";
import { UiFieldMessagePosition } from "../../generated/UiFieldMessagePosition";
import Logger = log.Logger;
export interface ValueChangeEventData {
    value: any;
}
export declare abstract class UiField<C extends UiFieldConfig = UiFieldConfig, V = any> extends UiComponent<C> implements UiFieldCommandHandler, UiFieldEventSource {
    readonly onValueChanged: TeamAppsEvent<UiField_ValueChangedEvent>;
    readonly onFocused: TeamAppsEvent<void>;
    readonly onBlurred: TeamAppsEvent<void>;
    readonly onUserManipulation: TeamAppsEvent<void>;
    static editingModeCssClasses: {
        [x: number]: string;
    };
    protected logger: Logger;
    private committedValue;
    private editingMode;
    private $fieldWrapper;
    private _messageTooltip;
    private $messagesContainerAbove;
    private $messagesContainerBelow;
    private fieldMessages;
    private hovering;
    constructor(_config: C, _context: TeamAppsUiContext);
    private updateFieldMessageVisibilities;
    private getHighestVisibilitiesByMessagePosition;
    protected abstract initialize(config: C, context: TeamAppsUiContext): void;
    getTeamAppsType(): string;
    getMainDomElement(): JQuery;
    abstract getMainInnerDomElement(): JQuery;
    abstract getFocusableElement(): JQuery;
    hasFocus(): boolean;
    focus(): void;
    destroy(): void;
    protected doDestroy(): void;
    abstract isValidData(v: V): boolean;
    abstract getTransientValue(): V;
    abstract getDefaultValue(): V;
    protected abstract displayCommittedValue(): void;
    abstract valuesChanged(v1: V, v2: V): boolean;
    setValue(value: any): void;
    setCommittedValue(v: V): void;
    getCommittedValue(): V;
    private fireCommittedChangeEvent;
    protected convertValueForSendingToServer(value: V): any;
    commit(forceEvenIfNotChanged?: boolean): boolean;
    setEditingMode(editingMode: UiFieldEditingMode): void;
    protected abstract onEditingModeChanged(editingMode: UiFieldEditingMode, oldEditingMode?: UiFieldEditingMode): void;
    getEditingMode(): UiFieldEditingMode;
    isEditable(): boolean;
    static defaultOnEditingModeChangedImpl(field: UiField<UiFieldConfig, any>): void;
    getReadOnlyHtml(value: V, availableWidth: number): string;
    getFieldMessages(): UiFieldMessageConfig[];
    setFieldMessages(fieldMessageConfigs: UiFieldMessageConfig[]): void;
    private createMessageElement;
    private readonly messageTooltip;
    private updatePopperPosition;
    protected getMessagesContainer(position: UiFieldMessagePosition): JQuery<HTMLElement>;
}
