import { UiField } from "./UiField";
import { UiFieldEditingMode } from "../../generated/UiFieldEditingMode";
import { TeamAppsUiContext } from "../TeamAppsUiContext";
import { UiTextFieldConfig, UiTextFieldCommandHandler, UiTextFieldEventSource } from "../../generated/UiTextFieldConfig";
import { TeamAppsEvent } from "../util/TeamAppsEvent";
import { UiTextInputHandlingField_SpecialKeyPressedEvent, UiTextInputHandlingField_TextInputEvent } from "../../generated/UiTextInputHandlingFieldConfig";
export declare class UiTextField<C extends UiTextFieldConfig = UiTextFieldConfig> extends UiField<C, string> implements UiTextFieldEventSource, UiTextFieldCommandHandler {
    readonly onTextInput: TeamAppsEvent<UiTextInputHandlingField_TextInputEvent>;
    readonly onSpecialKeyPressed: TeamAppsEvent<UiTextInputHandlingField_SpecialKeyPressedEvent>;
    private $wrapper;
    protected $field: JQuery;
    private showClearButton;
    protected initialize(config: C, context: TeamAppsUiContext): void;
    private fireTextInput;
    isValidData(v: string): boolean;
    setMaxCharacters(maxCharacters: number): void;
    setShowClearButton(showClearButton: boolean): void;
    private updateClearButton;
    setEmptyText(emptyText: string): void;
    getMainInnerDomElement(): JQuery;
    getFocusableElement(): JQuery;
    protected displayCommittedValue(): void;
    getTransientValue(): string;
    focus(): void;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    getReadOnlyHtml(value: string, availableWidth: number): string;
    getDefaultValue(): string;
    valuesChanged(v1: string, v2: string): boolean;
}
