import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiNotificationBar_ItemClickedEvent, UiNotificationBar_ItemClosedEvent, UiNotificationBarCommandHandler, UiNotificationBarConfig, UiNotificationBarEventSource } from "../generated/UiNotificationBarConfig";
import { UiNotificationBarItemConfig } from "../generated/UiNotificationBarItemConfig";
import { UiExitAnimation } from "../generated/UiExitAnimation";
import { UiEntranceAnimation } from "../generated/UiEntranceAnimation";
export declare class UiNotificationBar extends AbstractUiComponent<UiNotificationBarConfig> implements UiNotificationBarCommandHandler, UiNotificationBarEventSource {
    readonly onItemClicked: TeamAppsEvent<UiNotificationBar_ItemClickedEvent>;
    readonly onItemClosed: TeamAppsEvent<UiNotificationBar_ItemClosedEvent>;
    private $main;
    private itemsById;
    constructor(config: UiNotificationBarConfig, context: TeamAppsUiContext);
    doGetMainElement(): HTMLElement;
    addItem(itemConfig: UiNotificationBarItemConfig, entranceAnimation: UiEntranceAnimation, exitAnimation: UiExitAnimation): void;
    removeItem(id: string, exitAnimation?: UiExitAnimation): void;
}
