/*!
Trivial Components (https://github.com/trivial-components/trivial-components)

Copyright 2016 Yann Massard (https://github.com/yamass) and other contributors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
import { TrivialTreeBox, TrivialTreeBoxConfig } from "./TrivialTreeBox";
import { QueryFunction, TrivialComponent } from "./TrivialCore";
import { TrivialEvent } from "./TrivialEvent";
export declare type SearchBarMode = 'none' | 'show-if-filled' | 'always-visible';
export interface TrivialTreeConfig<E> extends TrivialTreeBoxConfig<E> {
    /**
     * Calculates the value to be set on the original input.
     */
    inputValueFunction?: (entry: E) => number | string;
    /**
     * Used to retrieve the filtered entries when the user types something into the search input.
     *
     * @see QueryFunction
     * @default creates a client-side query function using the provided [[entries]]
     */
    queryFunction?: QueryFunction<E>;
    /**
     * Whether and when the search input is shown.
     */
    searchBarMode?: SearchBarMode;
    directSelectionViaArrowKeys?: boolean;
    performanceOptimizationSettings?: {
        toManyVisibleItemsRenderDelay: number;
        toManyVisibleItemsThreshold: number;
    };
}
export declare class TrivialTree<E> implements TrivialComponent {
    private config;
    readonly onSelectedEntryChanged: TrivialEvent<E>;
    readonly onNodeExpansionStateChanged: TrivialEvent<E>;
    private treeBox;
    private entries;
    private selectedEntryId;
    private $spinners;
    private $originalInput;
    private $componentWrapper;
    private $editor;
    private processUpdateTimer;
    constructor(originalInput: JQuery | Element, options?: TrivialTreeConfig<E>);
    updateEntries(newEntries: E[]): void;
    private query;
    private countVisibleEntries;
    private findEntries;
    private findEntryById;
    private setSelectedEntry;
    private fireChangeEvents;
    getSelectedEntry(): void;
    updateChildren(parentNodeId: any, children: E[]): void;
    updateNode(node: E): void;
    removeNode(nodeId: string | number): void;
    addNode(parentNodeId: string | number, node: E): void;
    addOrUpdateNode(parentNodeId: string | number, node: E): void;
    selectNodeById(nodeId: any): void;
    getTreeBox(): TrivialTreeBox<E>;
    getEditor(): Element;
    destroy(): void;
    getMainDomElement(): Element;
}
