import Moment = moment.Moment;
import moment from "moment-timezone";
export interface DateSuggestion {
    moment: Moment;
    ymdOrder: string;
}
export declare type YearMonthDayOrder = "YMD" | "YDM" | "MDY" | "MYD" | "DMY" | "DYM";
export interface Options {
    preferredDateFormat?: string;
    /**
     * By default, the engine favors future dates. This flag makes it favor past dates.
     */
    favorPastDates?: boolean;
}
export declare class TrivialDateSuggestionEngine {
    private options;
    constructor(options: Options);
    generateSuggestions(searchString: string, now: Moment | Date): DateSuggestion[];
    private removeDuplicates;
    static dateFormatToYmdOrder(dateFormat: string): YearMonthDayOrder;
    private static createSuggestion;
    generateSuggestionsForDigitsOnlyInput(input: string, today: Moment): DateSuggestion[];
    todayOrFavoriteDirection(m: Moment, today: Moment): boolean;
    private createSuggestionsForFragments;
    private findNextValidDate;
}
