import { AbstractUiComponent } from "../../AbstractUiComponent";
import { TeamAppsEvent } from "../../util/TeamAppsEvent";
import { UiMediaSoupV3WebRtcClient_ClickedEvent, UiMediaSoupV3WebRtcClient_ConnectionStateChangedEvent, UiMediaSoupV3WebRtcClient_ContextMenuRequestedEvent, UiMediaSoupV3WebRtcClient_SourceMediaTrackEndedEvent, UiMediaSoupV3WebRtcClient_SourceMediaTrackRetrievalFailedEvent, UiMediaSoupV3WebRtcClient_SubscribingFailedEvent, UiMediaSoupV3WebRtcClient_SubscribingSuccessfulEvent, UiMediaSoupV3WebRtcClient_SubscriptionPlaybackFailedEvent, UiMediaSoupV3WebRtcClient_TrackPublishingFailedEvent, UiMediaSoupV3WebRtcClient_TrackPublishingSuccessfulEvent, UiMediaSoupV3WebRtcClient_VoiceActivityChangedEvent, UiMediaSoupV3WebRtcClientCommandHandler, UiMediaSoupV3WebRtcClientConfig, UiMediaSoupV3WebRtcClientEventSource } from "../../../generated/UiMediaSoupV3WebRtcClientConfig";
import { TeamAppsUiContext } from "../../TeamAppsUiContext";
import { UiMediaSoupPublishingParametersConfig } from "../../../generated/UiMediaSoupPublishingParametersConfig";
import { UiComponent } from "../../UiComponent";
import { UiMediaSoupPlaybackParametersConfig } from "../../../generated/UiMediaSoupPlaybackParametersConfig";
import { UiMediaDeviceInfoConfig } from "../../../generated/UiMediaDeviceInfoConfig";
export declare class UiMediaSoupV3WebRtcClient extends AbstractUiComponent<UiMediaSoupV3WebRtcClientConfig> implements UiMediaSoupV3WebRtcClientCommandHandler, UiMediaSoupV3WebRtcClientEventSource {
    readonly onSourceMediaTrackRetrievalFailed: TeamAppsEvent<UiMediaSoupV3WebRtcClient_SourceMediaTrackRetrievalFailedEvent>;
    readonly onSourceMediaTrackEnded: TeamAppsEvent<UiMediaSoupV3WebRtcClient_SourceMediaTrackEndedEvent>;
    readonly onTrackPublishingSuccessful: TeamAppsEvent<UiMediaSoupV3WebRtcClient_TrackPublishingSuccessfulEvent>;
    readonly onTrackPublishingFailed: TeamAppsEvent<UiMediaSoupV3WebRtcClient_TrackPublishingFailedEvent>;
    readonly onSubscribingSuccessful: TeamAppsEvent<UiMediaSoupV3WebRtcClient_SubscribingSuccessfulEvent>;
    readonly onSubscribingFailed: TeamAppsEvent<UiMediaSoupV3WebRtcClient_SubscribingFailedEvent>;
    readonly onSubscriptionPlaybackFailed: TeamAppsEvent<UiMediaSoupV3WebRtcClient_SubscriptionPlaybackFailedEvent>;
    readonly onConnectionStateChanged: TeamAppsEvent<UiMediaSoupV3WebRtcClient_ConnectionStateChangedEvent>;
    readonly onVoiceActivityChanged: TeamAppsEvent<UiMediaSoupV3WebRtcClient_VoiceActivityChangedEvent>;
    readonly onClicked: TeamAppsEvent<UiMediaSoupV3WebRtcClient_ClickedEvent>;
    readonly onContextMenuRequested: TeamAppsEvent<UiMediaSoupV3WebRtcClient_ContextMenuRequestedEvent>;
    private $main;
    private $image;
    private $videoContainer;
    private $video;
    private $profileDisplay;
    private $bitrateDisplayWrapper;
    private $audioBitrateDisplay;
    private $videoBitrateDisplay;
    private $icons;
    private $caption;
    private $spinner;
    private $unmuteButtonWrapper;
    private contextMenu;
    private conferenceClient;
    private audioTrack;
    private webcamTrack;
    private screenTrack;
    private videoTrackMixer;
    private targetStream;
    private connectionStatus;
    constructor(config: UiMediaSoupV3WebRtcClientConfig, context: TeamAppsUiContext);
    doGetMainElement(): HTMLElement;
    private updateStateCssClasses;
    private stop;
    private updatePromise;
    private counter;
    update(config: UiMediaSoupV3WebRtcClientConfig): void;
    updateInternal(config: UiMediaSoupV3WebRtcClientConfig): Promise<void>;
    private updateConferenceClient;
    updatePlayback(newParams: UiMediaSoupPlaybackParametersConfig): Promise<void>;
    private startVideoPlayback;
    private makeSafariVideoElementObserveMediaStreamTracks;
    updatePublishing(newParams: UiMediaSoupPublishingParametersConfig): Promise<void>;
    private updatePublishedTracks;
    private registerStatuslListeners;
    private updateVideoVisibility;
    setActive(active: boolean): void;
    private isVideoShown;
    onResize(): void;
    setContextMenuContent(requestId: number, component: UiComponent): void;
    closeContextMenu(requestId: number): void;
    static enumerateDevices(): Promise<UiMediaDeviceInfoConfig[]>;
    private static convertServerListToConferenceInputOrigin;
}
