import { TrivialComboBox } from "../../trivial-components/TrivialComboBox";
import moment from "moment-timezone";
import { UiFieldEditingMode } from "../../../generated/UiFieldEditingMode";
import { UiField } from "../UiField";
import { TeamAppsUiContext } from "../../TeamAppsUiContext";
import { UiTextInputHandlingField_SpecialKeyPressedEvent, UiTextInputHandlingField_TextInputEvent } from "../../../generated/UiTextInputHandlingFieldConfig";
import { TeamAppsEvent } from "../../util/TeamAppsEvent";
import { AbstractUiDateFieldCommandHandler, AbstractUiDateFieldConfig, AbstractUiDateFieldEventSource } from "../../../generated/AbstractUiDateFieldConfig";
import Moment = moment.Moment;
export interface DateComboBoxEntry {
    day: number;
    weekDay: string;
    month: number;
    year: number;
    displayString: string;
}
export declare abstract class AbstractUiDateField<C extends AbstractUiDateFieldConfig, V> extends UiField<C, V> implements AbstractUiDateFieldEventSource, AbstractUiDateFieldCommandHandler {
    readonly onTextInput: TeamAppsEvent<UiTextInputHandlingField_TextInputEvent>;
    readonly onSpecialKeyPressed: TeamAppsEvent<UiTextInputHandlingField_SpecialKeyPressedEvent>;
    static comboBoxTemplate: string;
    private $originalInput;
    protected trivialComboBox: TrivialComboBox<DateComboBoxEntry>;
    private dateSuggestionEngine;
    private favorPastDates;
    private dateFormat;
    protected initialize(config: AbstractUiDateFieldConfig, context: TeamAppsUiContext): void;
    private updateDateSuggestionEngine;
    getMainInnerDomElement(): HTMLElement;
    getFocusableElement(): HTMLElement;
    protected getDateFormat(): string;
    static createDateComboBoxEntryFromMoment(m: Moment, dateFormat: string): DateComboBoxEntry;
    static createDateComboBoxEntryFromLocalValues(year: number, month: number, day: number, dateFormat: string): DateComboBoxEntry;
    focus(): void;
    hasFocus(): boolean;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    destroy(): void;
    getDefaultValue(): V;
    setDateFormat(dateFormat: string): void;
    setFavorPastDates(favorPastDates: boolean): void;
    setShowDropDownButton(showDropDownButton: boolean): void;
    setShowClearButton(showClearButton: boolean): void;
}
