import { UiTemplateConfig } from "../generated/UiTemplateConfig";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiGridTemplateConfig } from "../generated/UiGridTemplateConfig";
import { UiTemplateReferenceConfig } from "../generated/UiTemplateReferenceConfig";
import { UiTextCellTemplateConfig } from "../generated/UiTextCellTemplateConfig";
import { Renderer } from "./Common";
export declare class TemplateRegistry {
    private context;
    static readonly NOOP_RENDERER: Renderer;
    readonly onTemplateRegistered: TeamAppsEvent<string>;
    private static logger;
    private renderersByName;
    constructor(context: TeamAppsUiContext);
    registerTemplate(name: string, template: UiTemplateConfig): void;
    getTemplateRendererByName(name: string): Renderer;
    getRegisteredTemplateConfigs(): {
        [name: string]: UiTemplateConfig;
    };
    createTemplateRenderer(template: UiTemplateConfig, idPropertyName?: string): Renderer;
    createTemplateRenderers(templates: {
        [name: string]: UiTemplateConfig;
    }, idPropertyName?: string): {
        [name: string]: Renderer;
    };
    convertToWrappedTagMustacheTemplates(templates: {
        [name: string]: UiTemplateConfig;
    }, idPropertyName?: string): {
        [name: string]: Renderer;
    };
}
export declare function isTemplateReference(template: UiTemplateConfig): template is UiTemplateReferenceConfig;
export declare function isTextCellTemplate(template: any): template is UiTextCellTemplateConfig;
export declare function isGridTemplate(template: UiTemplateConfig): template is UiGridTemplateConfig;
