import { UiComponentConfig } from "../../generated/UiComponentConfig";
import { UiComponent } from "../UiComponent";
import { SplitPaneItem } from "./SplitPaneItem";
import { View } from "./View";
import { TabPanelItem } from "./TabPanelItem";
export interface ItemTreeItem<C extends UiComponent<UiComponentConfig> = UiComponent<UiComponentConfig>> {
    id: string;
    parent: SplitPaneItem;
    component: C;
    itemIds: string[];
    viewNames: string[];
}
export declare class ItemTree {
    private static logger;
    private _rootItem;
    private _viewsByName;
    rootItem: ItemTreeItem<UiComponent<UiComponentConfig>>;
    readonly views: View[];
    readonly viewNames: string[];
    readonly viewCount: number;
    readonly viewsByName: {
        [viewName: string]: View;
    };
    updateIndex(): void;
    getViewByName(viewName: string): View;
    private doForEachItemAndView;
    getAllTabPanelItems(): TabPanelItem[];
    getTabPanelForView(viewName: string): TabPanelItem;
    getTabPanelById(itemId: string): TabPanelItem;
}
