/*!
Trivial Components (https://github.com/trivial-components/trivial-components)

Copyright 2016 Yann Massard (https://github.com/yamass) and other contributors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
import moment from "moment-timezone";
import Moment = moment.Moment;
import { NavigationDirection, TrivialComponent } from "./TrivialCore";
import { TrivialEvent } from "./TrivialEvent";
export declare enum WeekDay {
    MONDAY = 1,
    TUESDAY = 2,
    WEDNESDAY = 3,
    THURSDAY = 4,
    FRIDAY = 5,
    SATURDAY = 6,
    SUNDAY = 7
}
export declare type TimeUnit = 'year' | 'month' | 'day' | 'hour' | 'minute';
export interface TrivialCalendarBoxConfig {
    selectedDate?: Moment;
    firstDayOfWeek?: WeekDay;
    mode?: 'date' | 'time' | 'datetime';
    highlightKeyboardNavigationState?: boolean;
}
export declare class TrivialCalendarBox implements TrivialComponent {
    private $container;
    private config;
    private keyboardNavigationState;
    private keyboardNavCssClass;
    private selectedDate;
    private $calendarBox;
    private $calendarDisplay;
    private $yearDisplay;
    private $monthDisplay;
    private $monthTable;
    private $year;
    private $month;
    private $clockDisplay;
    private $hourHand;
    private $minuteHand;
    private $amPmText;
    private $digitalTimeHourDisplayWrapper;
    private $digitalTimeHourDisplay;
    private $digitalTimeMinuteDisplayWrapper;
    private $digitalTimeMinuteDisplay;
    readonly onChange: TrivialEvent<{
        value: moment.Moment;
        timeUnitEdited: TimeUnit;
    }>;
    readonly onOnEditingTimeUnitChange: TrivialEvent<TimeUnit>;
    constructor($container: JQuery | Element | string, options?: TrivialCalendarBoxConfig);
    private static getDaysForCalendarDisplay;
    private updateMonthDisplay;
    private updateClockDisplay;
    private updateDisplay;
    setSelectedDate(moment: Moment): void;
    setYear(year: number, fireEvent?: boolean): void;
    setMonth(month: number, fireEvent?: boolean): void;
    setDayOfMonth(dayOfMonth: number, fireEvent?: boolean): void;
    setMonthAndDay(month: number, day: number, fireEvent?: boolean): void;
    setHour(hour: number, fireEvent?: boolean): void;
    setMinute(minute: number, fireEvent?: boolean): void;
    private fireChangeEvents;
    setKeyboardNavigationState(newKeyboardNavigationState: TimeUnit): void;
    getSelectedDate(): moment.Moment;
    private navigateByUnit;
    navigate(direction: NavigationDirection): void;
    getMainDomElement(): Element;
    destroy(): void;
}
