/*!
 Trivial Components (https://github.com/trivial-components/trivial-components)

 Copyright 2016 Yann Massard (https://github.com/yamass) and other contributors

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
import Moment = moment.Moment;
import moment from "moment-timezone";
import { EditingMode, TrivialComponent } from "./TrivialCore";
import { TrivialEvent } from "./TrivialEvent";
export interface TrivialDateTimeFieldConfig {
    dateFormat?: string;
    timeFormat?: string;
    autoComplete?: boolean;
    autoCompleteDelay?: number;
    showTrigger?: boolean;
    editingMode?: EditingMode;
    favorPastDates?: boolean;
}
export interface LocalDate {
    year: number;
    month: number;
    day: number;
}
export interface LocalTime {
    hour: number;
    minute: number;
    second?: number;
}
export interface LocalDateTime extends LocalDate, LocalTime {
}
export declare class TrivialDateTimeField implements TrivialComponent {
    private config;
    private dateIconRenderer;
    private dateRenderer;
    private timeIconRenderer;
    private timeRenderer;
    readonly onChange: TrivialEvent<LocalDateTime>;
    private dateListBox;
    private timeListBox;
    private calendarBox;
    private _isDropDownOpen;
    private dateValue;
    private timeValue;
    private blurCausedByClickInsideComponent;
    private focusGoesToOtherEditor;
    private autoCompleteTimeoutId;
    private doNoAutoCompleteBecauseBackspaceWasPressed;
    private calendarBoxInitialized;
    private editingMode;
    private dropDownMode;
    private $originalInput;
    private $dateTimeField;
    private $dropDown;
    private $dateIconWrapper;
    private $dateEditor;
    private $timeIconWrapper;
    private $timeEditor;
    private $dropDownTargetElement;
    private $dateListBoxWrapper;
    private $timeListBoxWrapper;
    private $calendarBoxWrapper;
    private $activeEditor;
    private dateSuggestionEngine;
    private timeSuggestionEngine;
    constructor(originalInput: Element, options?: TrivialDateTimeFieldConfig);
    private isDropDownNeeded;
    private setDropDownMode;
    private getActiveBox;
    private getActiveEditor;
    private selectHighlightedListBoxEntry;
    private query;
    getValue(): LocalDateTime;
    private fireChangeEvents;
    private setDate;
    private setTime;
    private updateOriginalInputValue;
    private updateDisplay;
    setValue(mom: Moment): void;
    private repositionDropDown;
    openDropDown(): void;
    closeDropDown(): void;
    private getNonSelectedEditorValue;
    private autoCompleteIfPossible;
    private updateEntries;
    setEditingMode(newEditingMode: EditingMode): void;
    private static createTimeComboBoxEntry;
    private static pad;
    private static createDateComboBoxEntry;
    focus(): void;
    isDropDownOpen(): boolean;
    destroy(): void;
    getMainDomElement(): Element;
}
