import { UiComponentConfig } from "../../generated/UiComponentConfig";
import { SplitPaneItem } from "./SplitPaneItem";
import { View } from "./View";
import { TabPanelItem } from "./TabPanelItem";
import { UiComponent } from "../UiComponent";
export interface ItemTreeItem<C extends UiComponent<UiComponentConfig> = UiComponent<UiComponentConfig>> {
    id: string;
    parent: SplitPaneItem;
    component: C;
    itemIds: string[];
    viewNames: string[];
}
export declare class ItemTree {
    private static logger;
    private _rootItem;
    private _viewsByName;
    set rootItem(item: ItemTreeItem<UiComponent<UiComponentConfig>>);
    get rootItem(): ItemTreeItem<UiComponent<UiComponentConfig>>;
    get views(): View[];
    get viewNames(): string[];
    get viewCount(): number;
    get viewsByName(): {
        [viewName: string]: View;
    };
    updateIndex(): void;
    getViewByName(viewName: string): View;
    private doForEachItemAndView;
    getAllTabPanelItems(): TabPanelItem[];
    getTabPanelForView(viewName: string): TabPanelItem;
    getTabPanelById(itemId: string): TabPanelItem;
}
