import moment from "moment-timezone";
import { UiFieldEditingMode } from "../../../generated/UiFieldEditingMode";
import { TrivialComboBox } from "../../trivial-components/TrivialComboBox";
import { UiField } from "./../UiField";
import { TeamAppsUiContext } from "../../TeamAppsUiContext";
import { UiTextInputHandlingField_SpecialKeyPressedEvent, UiTextInputHandlingField_TextInputEvent } from "../../../generated/UiTextInputHandlingFieldConfig";
import { TeamAppsEvent } from "../../util/TeamAppsEvent";
import { AbstractUiTimeFieldCommandHandler, AbstractUiTimeFieldConfig, AbstractUiTimeFieldEventSource } from "../../../generated/AbstractUiTimeFieldConfig";
export declare abstract class AbstractUiTimeField<C extends AbstractUiTimeFieldConfig, V> extends UiField<C, V> implements AbstractUiTimeFieldEventSource, AbstractUiTimeFieldCommandHandler {
    readonly onTextInput: TeamAppsEvent<UiTextInputHandlingField_TextInputEvent>;
    readonly onSpecialKeyPressed: TeamAppsEvent<UiTextInputHandlingField_SpecialKeyPressedEvent>;
    static comboBoxTemplate: string;
    private $originalInput;
    protected trivialComboBox: TrivialComboBox<any>;
    private timeFormat;
    protected initialize(config: AbstractUiTimeFieldConfig, context: TeamAppsUiContext): void;
    getMainInnerDomElement(): HTMLElement;
    getFocusableElement(): HTMLElement;
    protected getTimeFormat(): string;
    focus(): void;
    hasFocus(): boolean;
    private static intRange;
    private static pad;
    static createTimeComboBoxEntry(h: number, m: number, timeFormat: string): {
        hour: number;
        minute: number;
        hourString: string;
        minuteString: string;
        displayString: string;
        hourAngle: number;
        minuteAngle: number;
        isNight: boolean;
    };
    static createTimeComboBoxEntryFromMoment(mom: moment.Moment, timeFormat: string): {
        hour: number;
        minute: number;
        hourString: string;
        minuteString: string;
        displayString: string;
        hourAngle: number;
        minuteAngle: number;
        isNight: boolean;
    };
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    destroy(): void;
    getDefaultValue(): V;
    setTimeFormat(timeFormat: string): void;
    setShowDropDownButton(showDropDownButton: boolean): void;
    setShowClearButton(showClearButton: boolean): void;
}
