export declare type MixSizingInfo = {
    fullCanvas?: boolean;
    width?: number;
    height?: number;
    left?: number;
    top?: number;
    right?: number;
    bottom?: number;
    flipX?: boolean;
    onRender?: (context: CanvasRenderingContext2D, video: HTMLVideoElement, mixSizingInfo: MixSizingInfo, x: number, y: number, width: number, height: number) => void;
};
export declare type TrackWithMixSizingInfo = {
    mediaTrack: MediaStreamTrack;
    mixSizingInfo: MixSizingInfo;
};
export declare type TrackWithMixSizingInfoAndVideo = TrackWithMixSizingInfo & {
    videoElement?: HTMLVideoElement;
};
export declare class VideoTrackMixer {
    private readonly inputTracks;
    private readonly canvas;
    private readonly context;
    private readonly frameRate;
    private drawVideoIntervalId;
    private outputTrack?;
    constructor(inputMediaStreamTracks: TrackWithMixSizingInfo[], frameRate?: number);
    getMixedTrack(): MediaStreamTrack;
    private getMixedVideoTrack;
    private drawVideosToCanvas;
    private drawImage;
    close(): void;
}
