import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiInfiniteItemView2_ContextMenuRequestedEvent, UiInfiniteItemView2_ItemClickedEvent, UiInfiniteItemView2_RenderedItemRangeChangedEvent, UiInfiniteItemView2CommandHandler, UiInfiniteItemView2Config, UiInfiniteItemView2EventSource } from "../generated/UiInfiniteItemView2Config";
import { UiTemplateConfig } from "../generated/UiTemplateConfig";
import { UiItemJustification } from "../generated/UiItemJustification";
import { UiIdentifiableClientRecordConfig } from "../generated/UiIdentifiableClientRecordConfig";
import { UiComponent } from "./UiComponent";
import { UiHorizontalElementAlignment } from "../generated/UiHorizontalElementAlignment";
import { UiVerticalElementAlignment } from "../generated/UiVerticalElementAlignment";
export declare var cssJustifyContent: {
    0: string;
    2: string;
    1: string;
    3: string;
};
export declare var cssAlignItems: {
    0: string;
    1: string;
    2: string;
    3: string;
};
export declare class UiInfiniteItemView2 extends AbstractUiComponent<UiInfiniteItemView2Config> implements UiInfiniteItemView2CommandHandler, UiInfiniteItemView2EventSource {
    readonly onRenderedItemRangeChanged: TeamAppsEvent<UiInfiniteItemView2_RenderedItemRangeChangedEvent>;
    readonly onItemClicked: TeamAppsEvent<UiInfiniteItemView2_ItemClickedEvent>;
    readonly onContextMenuRequested: TeamAppsEvent<UiInfiniteItemView2_ContextMenuRequestedEvent>;
    private $mainDomElement;
    private $grid;
    private $styles;
    private itemTemplateRenderer;
    private contextMenu;
    private renderedRange;
    private renderedIds;
    private renderedItems;
    private totalNumberOfRecords;
    private itemZIndexCounter;
    constructor(config: UiInfiniteItemView2Config, context: TeamAppsUiContext);
    setItemPositionAnimationTime(animationMillis: number): void;
    private requestDataIfNeededForScrollDebounced;
    private requestDataIfNeededForWheelDebounced;
    private requestDataIfNeeded;
    private getVisibleItemRange;
    private getItemsPerRow;
    private updateItemPositions;
    private createRenderedItem;
    private updateItemPosition;
    private rerenderAllItems;
    setData(startIndex: number, recordIds: number[], newRecords: UiIdentifiableClientRecordConfig[], totalNumberOfRecords: number): void;
    private updateGridHeight;
    onResize(): void;
    doGetMainElement(): HTMLElement;
    private updateStyles;
    setItemTemplate(itemTemplate: UiTemplateConfig): void;
    setItemWidth(itemWidth: number): void;
    setItemHeight(itemHeight: number): void;
    setHorizontalSpacing(horizontalSpacing: number): void;
    setVerticalSpacing(verticalSpacing: number): void;
    setItemContentHorizontalAlignment(itemContentHorizontalAlignment: UiHorizontalElementAlignment): void;
    setItemContentVerticalAlignment(itemContentVerticalAlignment: UiVerticalElementAlignment): void;
    setRowHorizontalAlignment(rowHorizontalAlignment: UiItemJustification): void;
    setContextMenuContent(requestId: number, component: UiComponent): void;
    closeContextMenu(requestId: number): void;
}
