/// <reference types="jquery" />
import KeyboardEventBase = JQuery.KeyboardEventBase;
export interface TrivialComponent {
    getMainDomElement(): Element;
    destroy(): void;
}
export declare type EditingMode = 'editable' | 'disabled' | 'readonly';
export declare type MatchingOptions = {
    matchingMode?: 'contains' | 'prefix' | 'prefix-word' | 'prefix-levenshtein' | 'levenshtein';
    ignoreCase?: boolean;
    maxLevenshteinDistance?: number;
};
export declare type Match = {
    start: number;
    length: number;
    distance?: number;
};
export declare type HighlightDirection = number | null | undefined;
export declare type NavigationDirection = "up" | "left" | "down" | "right";
export declare type ResultCallback<E> = (entries: E[]) => void;
/**
 * A function used to retrieve the entries ("suggestions") to be displayed in the dropdown box.
 * Does _not_ return any result. The entries need to be provided via the `resultCallback` function.
 *
 * @param queryString the text currently entered by the user
 * @param resultCallback the callback function to call with the entries to display in the dropdown
 */
export declare type QueryFunction<E> = (queryString: string, resultCallback: ResultCallback<E>) => void;
/**
 * Used to render an entry.
 *
 * @param entry the entry to render
 * @return HTML string
 */
export declare type RenderingFunction<E> = (entry: E) => string;
export declare const keyCodes: {
    backspace: number;
    tab: number;
    enter: number;
    shift: number;
    ctrl: number;
    alt: number;
    pause: number;
    caps_lock: number;
    escape: number;
    space: number;
    page_up: number;
    page_down: number;
    end: number;
    home: number;
    left_arrow: number;
    up_arrow: number;
    right_arrow: number;
    down_arrow: number;
    insert: number;
    delete: number;
    left_window_key: number;
    right_window_key: number;
    select_key: number;
    num_lock: number;
    scroll_lock: number;
    specialKeys: number[];
    numberKeys: number[];
    isSpecialKey: (keyCode: number) => boolean;
    isDigitKey: (keyCode: number) => boolean;
    isModifierKey(e: KeyboardEvent | KeyboardEventBase<any, any, any, any>): boolean;
};
export interface DefaultEntryStructure {
    imageUrl?: string;
    displayValue?: string;
    additionalInfo?: string;
    statusColor?: string;
}
export interface DefaultCurrencyEntryStructure {
    symbol?: string;
    code?: string;
    name?: string;
    exchangeRate?: string | number;
    exchangeRateBase?: string;
}
export declare const DEFAULT_RENDERING_FUNCTIONS: {
    image2Lines: (entry: DefaultEntryStructure) => string;
    roundImage2LinesColorBubble: (entry: DefaultEntryStructure) => string;
    icon2Lines: (entry: DefaultEntryStructure) => string;
    iconSingleLine: (entry: DefaultEntryStructure) => string;
    singleLine: (entry: DefaultEntryStructure) => string;
    currencySingleLineShort: (entry: DefaultCurrencyEntryStructure) => string;
    currencySingleLineLong: (entry: DefaultCurrencyEntryStructure) => string;
    currency2Line: (entry: DefaultCurrencyEntryStructure) => string;
};
export declare const DEFAULT_TEMPLATES: {
    defaultSpinnerTemplate: string;
    defaultNoEntriesTemplate: string;
};
export declare function wrapWithDefaultTagWrapper(entryHtml: string, deleteButton?: boolean): string;
export declare function defaultListQueryFunctionFactory<E>(entries: E[], properties: (string | ((entry: E) => any))[], matchingOptions: MatchingOptions): QueryFunction<E>;
export declare type PropertyReadAccess<E> = (string | ((entry: E) => any));
export declare function extractValue<E>(entry: E, property: PropertyReadAccess<E>): any;
export declare function createProxy(delegate: any): any;
export declare function unProxyEntry(entry: any): any;
export declare function defaultEntryMatchingFunctionFactory(searchedPropertyNames: string[], matchingOptions: MatchingOptions): (entry: any, queryString: string, depth: number) => boolean;
export declare function defaultTreeQueryFunctionFactory(topLevelEntries: any[] | (() => any[]), entryMatchingFunction: (entry: any, queryString: string, nodeDepth: number) => boolean, childrenPropertyName: string, expandedPropertyName: string): (queryString: string, resultCallback: (entries: any[]) => void) => void;
export declare function selectElementContents(domElement: Node, start: number, end: number): void;
export declare const escapeSpecialRegexCharacter: (s: string) => string;
export declare function objectEquals(x: any, y: any): boolean;
/**
 * @param text
 * @param searchString
 * @param options matchingMode: 'prefix', 'prefix-word', 'contain', 'prefix-levenshtein', 'levenshtein';
 *        ignoreCase: boolean
 *        maxLevenshteinDistance: integer (number) - only for levenshtein
 * @returns array of matchers {start, length, distance}
 */
export declare function trivialMatch(text: string, searchString: string, options?: MatchingOptions): Match[];
export declare function minimallyScrollTo(element: Element | JQuery<Element>, target: Element | JQuery): void;
export declare function setTimeoutOrDoImmediately(f: Function, delay?: number): number;
export declare function generateUUID(): string;
