import { TrivialTreeBox, TrivialTreeBoxConfig } from "./TrivialTreeBox";
import { TrivialComponent } from "./TrivialCore";
import { TrivialEvent } from "./TrivialEvent";
export interface TrivialTreeConfig<E> extends TrivialTreeBoxConfig<E> {
    directSelectionViaArrowKeys?: boolean;
}
export declare class TrivialTree<E> implements TrivialComponent {
    private config;
    readonly onSelectedEntryChanged: TrivialEvent<E>;
    readonly onNodeExpansionStateChanged: TrivialEvent<E>;
    private treeBox;
    private entries;
    private selectedEntryId;
    private $spinners;
    private $componentWrapper;
    constructor(options?: TrivialTreeConfig<E>);
    updateEntries(newEntries: E[]): void;
    private findEntries;
    private findEntryById;
    private setSelectedEntry;
    private fireChangeEvents;
    getSelectedEntry(): void;
    updateChildren(parentNodeId: any, children: E[]): void;
    updateNode(node: E): void;
    removeNode(nodeId: string | number): void;
    addNode(parentNodeId: string | number, node: E): void;
    addOrUpdateNode(parentNodeId: string | number, node: E, recursiveUpdate?: boolean): void;
    selectNodeById(nodeId: any): void;
    getTreeBox(): TrivialTreeBox<E>;
    destroy(): void;
    getMainDomElement(): Element;
}
