/*!
Trivial Components (https://github.com/trivial-components/trivial-components)

Copyright 2016 Yann Massard (https://github.com/yamass) and other contributors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
import { EditingMode, QueryFunction, TrivialComponent } from "./TrivialCore";
import { TrivialEvent } from "./TrivialEvent";
import { TrivialTreeBoxConfig } from "./TrivialTreeBox";
export interface TrivialUnitBoxConfig<U> extends TrivialTreeBoxConfig<U> {
    unitValueProperty?: string;
    unitIdProperty?: string;
    locale?: string;
    decimalPrecision?: number;
    unitDisplayPosition?: 'left' | 'right';
    allowNullAmount?: boolean;
    selectedEntryRenderingFunction?: (entry: U) => string;
    amount?: number;
    noEntriesTemplate?: string;
    queryFunction?: QueryFunction<U>;
    queryOnNonNumberCharacters?: boolean;
    openDropdownOnEditorClick?: boolean;
    showTrigger?: boolean;
    editingMode?: EditingMode;
    /**
     * HTML string defining the spinner to be displayed while entries are being retrieved.
     */
    spinnerTemplate?: string;
}
export declare type TrivialUnitBoxChangeEvent<U> = {
    unit: string;
    unitEntry: U;
    amount: number;
    amountAsFloatingPointNumber: number;
};
export declare class TrivialUnitBox<U> implements TrivialComponent {
    private config;
    readonly onChange: TrivialEvent<TrivialUnitBoxChangeEvent<U>>;
    readonly onSelectedEntryChanged: TrivialEvent<U>;
    readonly onFocus: TrivialEvent<void>;
    readonly onBlur: TrivialEvent<void>;
    private listBox;
    private _isDropDownOpen;
    private entries;
    private selectedEntry;
    private blurCausedByClickInsideComponent;
    private $spinners;
    private $originalInput;
    private $editor;
    private $dropDownTargetElement;
    private $unitBox;
    private $selectedEntryAndTriggerWrapper;
    private $selectedEntryWrapper;
    private $dropDown;
    private popper;
    private editingMode;
    private usingDefaultQueryFunction;
    private numberFormat;
    private numberParser;
    constructor(originalInput: JQuery | Element, options?: TrivialUnitBoxConfig<U>);
    private getDecimalSeparator;
    private getThousandsSeparator;
    private ensureDecimalInput;
    private getQueryString;
    private getEditorValueNumberPart;
    private query;
    private fireSelectedEntryChangedEvent;
    private fireChangeEvents;
    setSelectedEntry(entry: U, fireEvent?: boolean, originalEvent?: unknown): void;
    private formatEditorValue;
    private cleanupEditorValue;
    private formatAmount;
    private repositionDropDown;
    openDropDown(): void;
    closeDropDown(): void;
    private updateOriginalInputValue;
    getAmount(): number;
    private isDropDownNeeded;
    setEditingMode(newEditingMode: EditingMode): void;
    private selectUnit;
    updateEntries(newEntries: U[]): void;
    getSelectedEntry(): U;
    setAmount(amount: number): void;
    focus(): void;
    getEditor(): Element;
    setUnitDisplayPosition(unitDisplayPosition: "left" | "right"): void;
    isDropDownOpen(): boolean;
    destroy(): void;
    getMainDomElement(): Element;
    setLocale(locale: string): void;
    setDecimalPrecision(precision: number): void;
    private updateNumberFormatAndParser;
}
