import { DateObjectUnits, DateTime, DateTimeFormatOptions, DiffOptions, Duration, DurationObject, DurationUnit, Interval, LocaleOptions, ToISODateOptions, ToISOTimeOptions, ToSQLOptions, Zone, ZoneOptions } from "luxon";
export declare type LocalDateObject = DateObjectUnits & LocaleOptions;
export declare class LocalDateTime implements Omit<DateTime, "zone" | "zoneName" | "valueOf" | "isInDST" | "isOffsetFixed" | "offsetNameShort" | "offsetNameLong" | "offset" | "setZone" | "diff" | "diffNow" | "endOf" | "equals" | "hasSame" | "minus" | "plus" | "reconfigure" | "set" | "setLocale" | "startOf" | "toJSDate" | "toMillis" | "toRelative" | "toRelativeCalendar" | "toRFC2822" | "toSeconds"> {
    private dateTime;
    constructor(dateTime: DateTime);
    static fromDateTime(dateTime: DateTime): LocalDateTime;
    static fromObject(obj: LocalDateObject): LocalDateTime;
    static local(): LocalDateTime;
    get day(): number;
    set day(value: number);
    get daysInMonth(): number;
    set daysInMonth(value: number);
    get daysInYear(): number;
    set daysInYear(value: number);
    get hour(): number;
    set hour(value: number);
    get invalidReason(): string | null;
    set invalidReason(value: string | null);
    get invalidExplanation(): string | null;
    set invalidExplanation(value: string | null);
    get isInLeapYear(): boolean;
    set isInLeapYear(value: boolean);
    get isValid(): boolean;
    set isValid(value: boolean);
    get locale(): string;
    set locale(value: string);
    get millisecond(): number;
    set millisecond(value: number);
    get minute(): number;
    set minute(value: number);
    get month(): number;
    set month(value: number);
    get monthLong(): string;
    set monthLong(value: string);
    get monthShort(): string;
    set monthShort(value: string);
    get numberingSystem(): string;
    set numberingSystem(value: string);
    get ordinal(): number;
    set ordinal(value: number);
    get outputCalendar(): string;
    set outputCalendar(value: string);
    get quarter(): number;
    set quarter(value: number);
    get second(): number;
    set second(value: number);
    get weekNumber(): number;
    set weekNumber(value: number);
    get weekYear(): number;
    set weekYear(value: number);
    get weekday(): number;
    set weekday(value: number);
    get weekdayLong(): string;
    set weekdayLong(value: string);
    get weekdayShort(): string;
    set weekdayShort(value: string);
    get weeksInWeekYear(): number;
    set weeksInWeekYear(value: number);
    get year(): number;
    set year(value: number);
    diff(other: LocalDateTime, unit?: DurationUnit | DurationUnit[], options?: DiffOptions): Duration;
    diffNow(unit?: DurationUnit | DurationUnit[], options?: DiffOptions): Duration;
    endOf(unit: DurationUnit): LocalDateTime;
    equals(other: LocalDateTime): boolean;
    get(unit: keyof DateTime): number;
    hasSame(other: LocalDateTime, unit: DurationUnit): boolean;
    minus(duration: Duration | number | DurationObject): LocalDateTime;
    plus(duration: Duration | number | DurationObject): LocalDateTime;
    reconfigure(properties: LocaleOptions): LocalDateTime;
    resolvedLocaleOpts(options?: DateTimeFormatOptions): Intl.ResolvedDateTimeFormatOptions;
    set(values: DateObjectUnits): LocalDateTime;
    setLocale(locale: string): LocalDateTime;
    startOf(unit: DurationUnit): LocalDateTime;
    toBSON(): Date;
    toFormat(format: string, options?: DateTimeFormatOptions): string;
    toHTTP(): string;
    toISO(options?: ToISOTimeOptions): string;
    toISODate(options?: ToISODateOptions): string;
    toISOTime(options?: ToISOTimeOptions): string;
    toISOWeekDate(): string;
    toJSON(): string;
    toZoned(zone: string | Zone, options?: ZoneOptions): DateTime;
    toUTC(offset?: number, options?: ZoneOptions): DateTime;
    toLocal(): DateTime;
    toLocaleParts(options?: LocaleOptions & DateTimeFormatOptions): (any & {
        type: string;
    })[];
    toLocaleString(options?: LocaleOptions & DateTimeFormatOptions): string;
    toObject(options?: {
        includeConfig?: boolean;
    }): LocalDateObject;
    toSQL(options?: ToSQLOptions): string;
    toSQLDate(): string;
    toSQLTime(options?: ToSQLOptions): string;
    toString(): string;
    until(other: DateTime): Interval;
}
