import { TrivialComboBox } from "../../trivial-components/TrivialComboBox";
import { DateSuggestionEngine } from "./DateSuggestionEngine";
import { UiFieldEditingMode } from "../../../generated/UiFieldEditingMode";
import { UiField } from "../UiField";
import { TeamAppsUiContext } from "../../TeamAppsUiContext";
import { UiTextInputHandlingField_SpecialKeyPressedEvent, UiTextInputHandlingField_TextInputEvent } from "../../../generated/UiTextInputHandlingFieldConfig";
import { TeamAppsEvent } from "../../util/TeamAppsEvent";
import { AbstractUiDateFieldCommandHandler, AbstractUiDateFieldConfig, AbstractUiDateFieldEventSource } from "../../../generated/AbstractUiDateFieldConfig";
import { UiDateTimeFormatDescriptorConfig } from "../../../generated/UiDateTimeFormatDescriptorConfig";
import { LocalDateTime } from "../../util/LocalDateTime";
export declare abstract class AbstractUiDateField<C extends AbstractUiDateFieldConfig, V> extends UiField<C, V> implements AbstractUiDateFieldEventSource, AbstractUiDateFieldCommandHandler {
    readonly onTextInput: TeamAppsEvent<UiTextInputHandlingField_TextInputEvent>;
    readonly onSpecialKeyPressed: TeamAppsEvent<UiTextInputHandlingField_SpecialKeyPressedEvent>;
    private $originalInput;
    protected trivialComboBox: TrivialComboBox<LocalDateTime>;
    protected dateSuggestionEngine: DateSuggestionEngine;
    protected dateRenderer: (time: LocalDateTime) => string;
    protected initialize(config: AbstractUiDateFieldConfig, context: TeamAppsUiContext): void;
    protected localDateTimeToString(entry: LocalDateTime): string;
    protected createDateRenderer(): (time: LocalDateTime) => string;
    private updateDateSuggestionEngine;
    getMainInnerDomElement(): HTMLElement;
    getFocusableElement(): HTMLElement;
    focus(): void;
    hasFocus(): boolean;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    destroy(): void;
    getDefaultValue(): V;
    setLocaleAndDateFormat(locale: string, dateFormat: UiDateTimeFormatDescriptorConfig): void;
    setFavorPastDates(favorPastDates: boolean): void;
    setShowDropDownButton(showDropDownButton: boolean): void;
    setShowClearButton(showClearButton: boolean): void;
}
