import { AbstractUiComponent } from "./AbstractUiComponent";
import { TeamAppsUiContext } from "./TeamAppsUiContext";
import { UiMap2_LocationChangedEvent, UiMap2_MapClickedEvent, UiMap2_MarkerClickedEvent, UiMap2_ShapeDrawnEvent, UiMap2_ZoomLevelChangedEvent, UiMap2CommandHandler, UiMap2Config, UiMap2EventSource } from "../generated/UiMap2Config";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiMapLocationConfig } from "../generated/UiMapLocationConfig";
import { UiMapMarkerClientRecordConfig } from "../generated/UiMapMarkerClientRecordConfig";
import { UiTemplateConfig } from "../generated/UiTemplateConfig";
import { AbstractUiMapShapeConfig } from "../generated/AbstractUiMapShapeConfig";
import { UiMapMarkerClusterConfig } from "../generated/UiMapMarkerClusterConfig";
export declare class UiMap2 extends AbstractUiComponent<UiMap2Config> implements UiMap2EventSource, UiMap2CommandHandler {
    readonly onZoomLevelChanged: TeamAppsEvent<UiMap2_ZoomLevelChangedEvent>;
    readonly onLocationChanged: TeamAppsEvent<UiMap2_LocationChangedEvent>;
    readonly onMapClicked: TeamAppsEvent<UiMap2_MapClickedEvent>;
    readonly onMarkerClicked: TeamAppsEvent<UiMap2_MarkerClickedEvent>;
    readonly onShapeDrawn: TeamAppsEvent<UiMap2_ShapeDrawnEvent>;
    private $map;
    private map;
    private markerTemplateRenderers;
    private markersByClientId;
    private shapeIds;
    private deferredExecutor;
    constructor(config: UiMap2Config, context: TeamAppsUiContext);
    setStyleUrl(styleUrl: string): void;
    addShape(shapeId: string, shapeConfig: AbstractUiMapShapeConfig): void;
    updateShape(shapeId: string, shape: AbstractUiMapShapeConfig): void;
    removeShape(shapeId: string): void;
    clearShapes(): void;
    setMapMarkerCluster(clusterConfig: UiMapMarkerClusterConfig): void;
    private createMarkersFeatureCollection;
    private createMarkerFeature;
    private convertToPosition;
    addMarker(markerConfig: UiMapMarkerClientRecordConfig): void;
    removeMarker(id: number): void;
    clearMarkers(): void;
    private createMarker;
    setHeatMap(data: import("../generated/UiHeatMapDataConfig").UiHeatMapDataConfig): void;
    startDrawingShape(shapeType: import("../generated/UiMapShapeType").UiMapShapeType, shapeProperties: import("../generated/UiShapePropertiesConfig").UiShapePropertiesConfig): void;
    stopDrawingShape(): void;
    setZoomLevel(zoom: number): void;
    setLocation(location: UiMapLocationConfig): void;
    fitBounds(southWest: UiMapLocationConfig, northEast: UiMapLocationConfig): void;
    registerTemplate(id: string, template: UiTemplateConfig): void;
    doGetMainElement(): HTMLElement;
    onResize(): void;
}
