import { UiConfigurationConfig } from "../generated/UiConfigurationConfig";
import { UiComponentConfig } from "../generated/UiComponentConfig";
import { UiEvent } from "../generated/UiEvent";
import { TemplateRegistry } from "./TemplateRegistry";
import { TeamAppsEvent } from "./util/TeamAppsEvent";
import { UiCommand } from "../generated/UiCommand";
import { UiClientObject } from "./UiClientObject";
import { UiClientObjectConfig } from "../generated/UiClientObjectConfig";
export declare const typescriptDeclarationFixConstant = 1;
export interface TeamAppsUiContext {
    readonly sessionId: string;
    readonly isHighDensityScreen: boolean;
    readonly executingCommand: boolean;
    readonly config: UiConfigurationConfig;
    readonly templateRegistry: TemplateRegistry;
    getClientObjectById(id: string): UiClientObject;
}
export interface TeamAppsUiContextInternalApi extends TeamAppsUiContext {
    readonly onStaticMethodCommandInvocation: TeamAppsEvent<UiCommand>;
    registerClientObject(component: UiClientObject, id: string, teamappsType: string): void;
    createClientObject(config: UiClientObjectConfig): UiClientObject;
    refreshComponent(config: UiComponentConfig): void;
    destroyClientObject(componentId: string): void;
    fireEvent(eventObject: UiEvent): void;
}
