import { AbstractUiToolContainer } from "../AbstractUiToolContainer";
import { TeamAppsEvent } from "../../util/TeamAppsEvent";
import { UiToolbarButtonGroupConfig } from "../../../generated/UiToolbarButtonGroupConfig";
import { UiToolbarButtonConfig } from "../../../generated/UiToolbarButtonConfig";
import { TeamAppsUiContext } from "../../TeamAppsUiContext";
import { UiToolAccordionCommandHandler, UiToolAccordionConfig, UiToolAccordionEventSource } from "../../../generated/UiToolAccordionConfig";
import { AbstractUiToolContainer_ToolbarButtonClickEvent, AbstractUiToolContainer_ToolbarDropDownItemClickEvent } from "../../../generated/AbstractUiToolContainerConfig";
import { UiComponent } from "../../UiComponent";
export declare class UiToolAccordion extends AbstractUiToolContainer<UiToolAccordionConfig> implements UiToolAccordionCommandHandler, UiToolAccordionEventSource {
    static DEFAULT_TOOLBAR_MAX_HEIGHT: number;
    readonly onToolbarButtonClick: TeamAppsEvent<AbstractUiToolContainer_ToolbarButtonClickEvent>;
    readonly onToolbarDropDownItemClick: TeamAppsEvent<AbstractUiToolContainer_ToolbarDropDownItemClickEvent>;
    private buttonGroupsById;
    private $mainDomElement;
    private $backgroundColorDiv;
    constructor(config: UiToolAccordionConfig, context: TeamAppsUiContext);
    doGetMainElement(): HTMLElement;
    private createButtonGroup;
    setButtonHasDropDown(groupId: string, buttonId: string, hasDropDown: boolean): void;
    setDropDownComponent(groupId: string, buttonId: string, component: UiComponent): void;
    setButtonVisible(groupId: string, buttonId: string, visible: boolean): void;
    setButtonColors(groupId: string, buttonId: string, backgroundColor: string, hoverBackgroundColor: string): void;
    setButtonGroupVisible(groupId: string, visible: boolean): void;
    addButtonGroup(buttonGroupConfig: UiToolbarButtonGroupConfig): void;
    removeButtonGroup(groupId: string): void;
    addButton(groupId: string, buttonConfig: UiToolbarButtonConfig, neighborButtonId: string, beforeNeighbor: boolean): void;
    removeButton(groupId: string, buttonId: string): void;
    updateButtonGroups(buttonGroups: UiToolbarButtonGroupConfig[]): void;
    refreshEnforcedButtonWidth(): void;
    onResize(): void;
}
