import { DropDownComponent, SelectionDirection } from "./DropDownComponent";
import { TeamAppsEvent } from "../../util/TeamAppsEvent";
import { QueryFunction } from "../TrivialCore";
import { TrivialTreeBox } from "../TrivialTreeBox";
declare type TreeBoxDropdownConfig<E> = {
    queryFunction: QueryFunction<E>;
    textHighlightingEntryLimit: number;
    preselectionMatcher: (query: string, entry: E) => boolean;
};
export declare class TreeBoxDropdown<E> implements DropDownComponent<E> {
    readonly onValueChanged: TeamAppsEvent<{
        value: E;
        finalSelection: boolean;
    }>;
    private treeBox;
    private config;
    constructor(config: TreeBoxDropdownConfig<E>, treeBox: TrivialTreeBox<E>);
    getMainDomElement(): HTMLElement;
    getValue(): E;
    handleKeyboardInput(event: KeyboardEvent): boolean;
    handleQuery(query: string, selectionDirection: SelectionDirection): Promise<boolean>;
    setValue(value: E): void;
    destroy(): void;
    getComponent(): TrivialTreeBox<E>;
}
export {};
