/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.dto;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.IOUtils;
import org.teamapps.cluster.dto.MessageField;
import org.teamapps.cluster.dto.MessageFieldType;
import org.teamapps.cluster.dto.MessageSchema;
import org.teamapps.cluster.dto.ServiceMethod;
import org.teamapps.cluster.dto.ServiceSchema;

public class PojoBuilder {
    public static void createPojos(MessageSchema schema, File directory) throws IOException {
        File dir = directory;
        String namespace = schema.getNamespace();
        for (String name : namespace.split("\\.")) {
            dir = new File(dir, name);
            dir.mkdir();
        }
        System.out.println("Create source in path: " + dir.getPath());
        File f = dir;
        PojoBuilder.createServiceClasses(schema, dir);
        PojoBuilder.createSchemaPojo(schema, dir);
        schema.getFields().stream().filter(field -> field.getType() == MessageFieldType.OBJECT).forEach(field -> PojoBuilder.createMessagePojoSave(schema, field, f));
    }

    private static void createServiceClasses(MessageSchema schema, File directory) throws IOException {
        for (ServiceSchema serviceSchema : schema.getServiceSchemas()) {
            String tpl = PojoBuilder.readTemplate("service.tpl");
            tpl = PojoBuilder.setValue(tpl, "package", schema.getNamespace());
            String type = "Abstract" + PojoBuilder.firstUpperCase(serviceSchema.getServiceName());
            tpl = PojoBuilder.setValue(tpl, "type", type);
            tpl = PojoBuilder.setValue(tpl, "serviceName", serviceSchema.getServiceName());
            StringBuilder data = new StringBuilder();
            StringBuilder cases = new StringBuilder();
            for (ServiceMethod method : serviceSchema.getServiceMethods()) {
                data.append(PojoBuilder.getTabs(1)).append("public abstract ").append(PojoBuilder.firstUpperCase(method.getOutputMessage().getName())).append(" ").append(method.getMethodName()).append("(").append(PojoBuilder.firstUpperCase(method.getInputMessage().getName())).append(" value);\n\n");
                cases.append(PojoBuilder.getTabs(3)).append("case \"").append(method.getMethodName()).append("\" -> {\n");
                cases.append(PojoBuilder.getTabs(4)).append("return ").append(method.getMethodName()).append("( new ").append(PojoBuilder.firstUpperCase(method.getInputMessage().getName())).append("(bytes, fileProvider)).toBytes(fileSink);\n");
                cases.append(PojoBuilder.getTabs(3)).append("}\n");
            }
            tpl = PojoBuilder.setValue(tpl, "methods", data.toString());
            tpl = PojoBuilder.setValue(tpl, "cases", cases.toString());
            File file = new File(directory, type + ".java");
            Files.writeString(file.toPath(), (CharSequence)tpl, new OpenOption[0]);
            type = PojoBuilder.firstUpperCase(serviceSchema.getServiceName()) + "Client";
            tpl = PojoBuilder.readTemplate("serviceClient.tpl");
            tpl = PojoBuilder.setValue(tpl, "package", schema.getNamespace());
            tpl = PojoBuilder.setValue(tpl, "type", type);
            tpl = PojoBuilder.setValue(tpl, "serviceName", serviceSchema.getServiceName());
            data = new StringBuilder();
            for (ServiceMethod method : serviceSchema.getServiceMethods()) {
                data.append(PojoBuilder.getTabs(1)).append("public Mono<").append(PojoBuilder.firstUpperCase(method.getOutputMessage().getName())).append("> ").append(method.getMethodName()).append("(").append(PojoBuilder.firstUpperCase(method.getInputMessage().getName())).append(" value) {\n");
                data.append(PojoBuilder.getTabs(2)).append("return createClusterTask(\"").append(method.getMethodName()).append("\", value, ").append(PojoBuilder.firstUpperCase(method.getOutputMessage().getName())).append(".getMessageDecoder());\n");
                data.append(PojoBuilder.getTabs(1)).append("}\n\n");
            }
            tpl = PojoBuilder.setValue(tpl, "methods", data.toString());
            file = new File(directory, type + ".java");
            Files.writeString(file.toPath(), (CharSequence)tpl, new OpenOption[0]);
        }
    }

    private static void createSchemaPojo(MessageSchema schema, File directory) throws IOException {
        String tpl = PojoBuilder.readTemplate("schema.tpl");
        tpl = PojoBuilder.setValue(tpl, "package", schema.getNamespace());
        tpl = PojoBuilder.setValue(tpl, "type", PojoBuilder.firstUpperCase(schema.getName()));
        tpl = PojoBuilder.setValue(tpl, "id", "" + schema.getSchemaId());
        tpl = PojoBuilder.setValue(tpl, "name", schema.getName());
        StringBuilder data = new StringBuilder();
        StringBuilder registry = new StringBuilder();
        for (MessageField field : schema.getFields()) {
            String title;
            int id = field.getId() - schema.getSchemaIdPrefix();
            int parentId = field.getParentFieldId() - schema.getSchemaIdPrefix();
            int referenceId = field.getReferencedFieldId() - schema.getSchemaIdPrefix();
            String string = title = field.getTitle() != null ? "\"" + field.getTitle() + "\"" : "null";
            if (field.isObject()) {
                data.append(PojoBuilder.getTabs(2)).append("MessageField f").append(id).append(" = SCHEMA.addObject(" + id + ", \"" + field.getName() + "\", " + title + ");\n");
                registry.append(PojoBuilder.getTabs(2)).append("DECODERS.put(").append(field.getId()).append(", ").append(PojoBuilder.firstUpperCase(field.getName())).append(".getMessageDecoder());\n");
                continue;
            }
            if (field.isSingleReference()) {
                data.append(PojoBuilder.getTabs(2)).append("SCHEMA.addSingleReference(f").append(parentId).append(", f").append(referenceId).append(", \"" + field.getName() + "\", " + title + ");\n");
                continue;
            }
            if (field.isMultiReference()) {
                data.append(PojoBuilder.getTabs(2)).append("SCHEMA.addMultiReference(f").append(parentId).append(", f").append(referenceId).append(", \"" + field.getName() + "\", " + title + ");\n");
                continue;
            }
            data.append(PojoBuilder.getTabs(2)).append("SCHEMA.addField(f" + parentId + ", " + id + ", \"" + field.getName() + "\", " + title + ", MessageFieldType." + field.getType().name() + ", MessageFieldContentType." + field.getContentType().name() + ", null);\n");
        }
        tpl = PojoBuilder.setValue(tpl, "data", data.toString());
        tpl = PojoBuilder.setValue(tpl, "registry", registry.toString());
        File file = new File(directory, PojoBuilder.firstUpperCase(schema.getName()) + ".java");
        Files.writeString(file.toPath(), (CharSequence)tpl, new OpenOption[0]);
    }

    private static void createMessagePojoSave(MessageSchema schema, MessageField field, File directory) {
        try {
            PojoBuilder.createMessagePojo(schema, field, directory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void createMessagePojo(MessageSchema schema, MessageField objectField, File directory) throws IOException {
        String tpl = PojoBuilder.readTemplate("pojo.tpl");
        tpl = PojoBuilder.setValue(tpl, "package", schema.getNamespace());
        tpl = PojoBuilder.setValue(tpl, "type", PojoBuilder.firstUpperCase(objectField.getName()));
        tpl = PojoBuilder.setValue(tpl, "schema", PojoBuilder.firstUpperCase(schema.getName()));
        tpl = PojoBuilder.setValue(tpl, "fieldId", "" + objectField.getId());
        StringBuilder data = new StringBuilder();
        for (MessageField field : objectField.getFields()) {
            data.append(PojoBuilder.getTabs(1)).append("public ").append(PojoBuilder.getReturnType(field, schema)).append(" get").append(PojoBuilder.firstUpperCase(field.getName())).append("() {\n");
            data.append(PojoBuilder.getTabs(2)).append("return ").append(PojoBuilder.getGetterMethod(field)).append("(\"").append(field.getName()).append("\");\n");
            data.append(PojoBuilder.getTabs(1)).append("}\n");
            data.append("\n");
            data.append(PojoBuilder.getTabs(1)).append("public " + PojoBuilder.firstUpperCase(objectField.getName()) + " set").append(PojoBuilder.firstUpperCase(field.getName())).append("(").append(PojoBuilder.getReturnType(field, schema)).append(" value) {\n");
            data.append(PojoBuilder.getTabs(2)).append("setPropertyValue(\"").append(field.getName()).append("\", value);\n");
            data.append(PojoBuilder.getTabs(2)).append("return this;\n");
            data.append(PojoBuilder.getTabs(1)).append("}\n");
            if (!field.isMultiReference()) continue;
            data.append("\n");
            data.append(PojoBuilder.getTabs(1)).append("public " + PojoBuilder.firstUpperCase(objectField.getName()) + " add").append(PojoBuilder.firstUpperCase(field.getName())).append("(").append(PojoBuilder.firstUpperCase(field.getReferencedField(schema).getName())).append(" value) {\n");
            data.append(PojoBuilder.getTabs(2)).append("addMultiReference(\"").append(field.getName()).append("\", value);\n");
            data.append(PojoBuilder.getTabs(2)).append("return this;\n");
            data.append(PojoBuilder.getTabs(1)).append("}\n");
        }
        tpl = PojoBuilder.setValue(tpl, "methods", data.toString());
        File file = new File(directory, PojoBuilder.firstUpperCase(objectField.getName()) + ".java");
        Files.writeString(file.toPath(), (CharSequence)tpl, new OpenOption[0]);
        System.out.println("Write pojo:" + file.getPath());
    }

    private static String readTemplate(String name) throws IOException {
        InputStream inputStream = PojoBuilder.class.getResourceAsStream("/templates/" + name);
        return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
    }

    private static String setValue(String template, String name, String value) {
        return template.replace("{" + name + "}", value);
    }

    private static String firstUpperCase(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    private static String getTabs(int count) {
        return "\t".repeat(count);
    }

    private static String getReturnType(MessageField field, MessageSchema schema) {
        return switch (field.getType()) {
            case MessageFieldType.OBJECT -> PojoBuilder.firstUpperCase(field.getName());
            case MessageFieldType.OBJECT_SINGLE_REFERENCE -> PojoBuilder.firstUpperCase(field.getReferencedField(schema).getName());
            case MessageFieldType.OBJECT_MULTI_REFERENCE -> "List<" + PojoBuilder.firstUpperCase(field.getReferencedField(schema).getName()) + ">";
            case MessageFieldType.BOOLEAN -> "boolean";
            case MessageFieldType.BYTE -> "byte";
            case MessageFieldType.INT -> "int";
            case MessageFieldType.LONG -> "long";
            case MessageFieldType.FLOAT -> "float";
            case MessageFieldType.DOUBLE -> "double";
            case MessageFieldType.STRING -> "String";
            case MessageFieldType.BITSET -> "BitSet";
            case MessageFieldType.BYTE_ARRAY -> "byte[]";
            case MessageFieldType.INT_ARRAY -> "int[]";
            case MessageFieldType.LONG_ARRAY -> "long[]";
            case MessageFieldType.FLOAT_ARRAY -> "float[]";
            case MessageFieldType.DOUBLE_ARRAY -> "double[]";
            case MessageFieldType.STRING_ARRAY -> "String[]";
            case MessageFieldType.FILE -> "File";
            case MessageFieldType.ENUM -> PojoBuilder.firstUpperCase(field.getName());
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private static String getGetterMethod(MessageField field) {
        return switch (field.getType()) {
            case MessageFieldType.OBJECT -> "getMessageObject";
            case MessageFieldType.OBJECT_SINGLE_REFERENCE -> "getMessageObject";
            case MessageFieldType.OBJECT_MULTI_REFERENCE -> "getMessageList";
            case MessageFieldType.BOOLEAN -> "getBooleanValue";
            case MessageFieldType.BYTE -> "getByteValue";
            case MessageFieldType.INT -> "getIntValue";
            case MessageFieldType.LONG -> "getLongValue";
            case MessageFieldType.FLOAT -> "getFloatValue";
            case MessageFieldType.DOUBLE -> "getDoubleValue";
            case MessageFieldType.STRING -> "getStringValue";
            case MessageFieldType.BITSET -> "getBitSetValue";
            case MessageFieldType.BYTE_ARRAY -> "getByteArrayValue";
            case MessageFieldType.INT_ARRAY -> "getIntArrayValue";
            case MessageFieldType.LONG_ARRAY -> "getLongArrayValue";
            case MessageFieldType.FLOAT_ARRAY -> "getFloatArrayValue";
            case MessageFieldType.DOUBLE_ARRAY -> "getDoubleArrayValue";
            case MessageFieldType.STRING_ARRAY -> "getStringArrayValue";
            case MessageFieldType.FILE -> "getFileValue";
            case MessageFieldType.ENUM -> "getIntValue";
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

