/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.cluster.network.ConnectionHandler;
import org.teamapps.cluster.network.NodeAddress;

public class Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int MAX_MESSAGE_SIZE = 10000000;
    private final ConnectionHandler connectionHandler;
    private final boolean outgoing;
    private volatile boolean active = true;
    private NodeAddress nodeAddress;
    private Socket socket;
    private DataInputStream dataInputStream;
    private DataOutputStream dataOutputStream;

    public Connection(ConnectionHandler connectionHandler, Socket socket, NodeAddress nodeAddress) {
        this.connectionHandler = connectionHandler;
        this.socket = socket;
        this.nodeAddress = nodeAddress;
        this.outgoing = false;
        this.connect();
    }

    public Connection(ConnectionHandler connectionHandler, NodeAddress nodeAddress) {
        this.connectionHandler = connectionHandler;
        this.nodeAddress = nodeAddress;
        this.outgoing = true;
        this.connect();
    }

    private void connect() {
        try {
            LOGGER.info("Connect, outgoing: {}, {}", (Object)this.outgoing, (Object)this.nodeAddress);
            this.openSocket();
            this.initializeSocket();
            this.startReaderThread();
        }
        catch (IOException e) {
            this.closeConnection();
        }
    }

    private synchronized void closeConnection() {
        if (!this.active) {
            return;
        }
        LOGGER.info("Close connection, outgoing: {}, {}", (Object)this.outgoing, (Object)this.nodeAddress);
        try {
            this.active = false;
            this.socket.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.socket = null;
            this.dataOutputStream = null;
            this.dataInputStream = null;
            this.connectionHandler.handleConnectionClosed();
        }
    }

    private void openSocket() throws IOException {
        if (this.outgoing) {
            this.socket = new Socket(this.nodeAddress.getHost(), this.nodeAddress.getPort());
        }
        this.dataInputStream = new DataInputStream(this.socket.getInputStream());
        this.dataOutputStream = new DataOutputStream(this.socket.getOutputStream());
    }

    private void initializeSocket() throws IOException {
        this.socket.setKeepAlive(true);
        this.socket.setTcpNoDelay(true);
    }

    private void startReaderThread() {
        String threadName = "connection-reader-" + this.socket.getInetAddress().getHostAddress() + "-" + this.socket.getPort();
        Thread thread = new Thread(() -> {
            while (this.active) {
                try {
                    int messageSize = this.dataInputStream.readInt();
                    if (messageSize > 0 && messageSize < 10000000) {
                        byte[] data = new byte[messageSize];
                        this.dataInputStream.readFully(data);
                        this.connectionHandler.handleMessage(data);
                        continue;
                    }
                    this.closeConnection();
                }
                catch (Exception e) {
                    this.closeConnection();
                }
            }
        });
        thread.setName(threadName);
        thread.setDaemon(true);
        thread.start();
    }

    public synchronized void writeMessage(byte[] bytes) {
        try {
            this.dataOutputStream.writeInt(bytes.length);
            this.dataOutputStream.write(bytes);
            this.dataOutputStream.flush();
        }
        catch (Exception e) {
            this.closeConnection();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isOutgoing() {
        return this.outgoing;
    }

    public NodeAddress getNodeAddress() {
        return this.nodeAddress;
    }
}

