package org.teamapps.cluster.message.protocol;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.*;
import java.time.*;



public class ClusterAvailableServicesUpdate extends Message {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<ClusterAvailableServicesUpdate> decoder = new PojoObjectDecoder<ClusterAvailableServicesUpdate>() {
		@Override
		public ClusterAvailableServicesUpdate decode(DataInputStream dis, FileDataReader fileDataReader) {
			try {
				return new ClusterAvailableServicesUpdate(dis, fileDataReader);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterAvailableServicesUpdate instance", e);
			}
			return null;
		}

		@Override
		public ClusterAvailableServicesUpdate decode(Element element, FileDataReader fileDataReader) {
			return new ClusterAvailableServicesUpdate(element, fileDataReader);
		}

        @Override
        public ClusterAvailableServicesUpdate decode(String xml, FileDataReader fileDataReader) {
            try {
                return new ClusterAvailableServicesUpdate(xml, fileDataReader);
            } catch (Exception e) {
                LOGGER.error("Error creating ClusterAvailableServicesUpdate instance", e);
            }
            return null;
        }

		@Override
		public ClusterAvailableServicesUpdate defaultMessage() {
			return (ClusterAvailableServicesUpdate) new ClusterAvailableServicesUpdate().setDefaultValues();
		}

		@Override
		public ClusterAvailableServicesUpdate remap(Message message) {
			return new ClusterAvailableServicesUpdate(message, ClusterMessageProtocol.MODEL_COLLECTION);
		}

        @Override
        public String getMessageUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<ClusterAvailableServicesUpdate> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterMessageProtocol.MODEL_COLLECTION;
	}

    public static ClusterAvailableServicesUpdate remap(Message message) {
        return new ClusterAvailableServicesUpdate(message, ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "cluster.clusterAvailableServicesUpdate";


	public ClusterAvailableServicesUpdate() {
		super(ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public ClusterAvailableServicesUpdate(Message message, ModelCollection modelCollection) {
		super(message, modelCollection);
	}

	public ClusterAvailableServicesUpdate(DataInputStream dis) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterAvailableServicesUpdate(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterAvailableServicesUpdate(byte[] bytes) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterAvailableServicesUpdate(byte[] bytes, FileDataReader fileDataReader) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterAvailableServicesUpdate(Element element, FileDataReader fileDataReader) {
		super(element, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

    public ClusterAvailableServicesUpdate(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
    }

	public String[] getServices() {
		return getStringArrayAttribute("services");
	}

	public ClusterAvailableServicesUpdate setServices(String[] value) {
		setStringArrayAttribute("services", value);
		return this;
	}



}