package org.teamapps.cluster.message.protocol;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.*;
import java.time.*;



public class ClusterConnectionRequest extends Message {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<ClusterConnectionRequest> decoder = new PojoObjectDecoder<ClusterConnectionRequest>() {
		@Override
		public ClusterConnectionRequest decode(DataInputStream dis, FileDataReader fileDataReader) {
			try {
				return new ClusterConnectionRequest(dis, fileDataReader);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterConnectionRequest instance", e);
			}
			return null;
		}

		@Override
		public ClusterConnectionRequest decode(Element element, FileDataReader fileDataReader) {
			return new ClusterConnectionRequest(element, fileDataReader);
		}

        @Override
        public ClusterConnectionRequest decode(String xml, FileDataReader fileDataReader) {
            try {
                return new ClusterConnectionRequest(xml, fileDataReader);
            } catch (Exception e) {
                LOGGER.error("Error creating ClusterConnectionRequest instance", e);
            }
            return null;
        }

		@Override
		public ClusterConnectionRequest defaultMessage() {
			return (ClusterConnectionRequest) new ClusterConnectionRequest().setDefaultValues();
		}

		@Override
		public ClusterConnectionRequest remap(Message message) {
			return new ClusterConnectionRequest(message, ClusterMessageProtocol.MODEL_COLLECTION);
		}

        @Override
        public String getMessageUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<ClusterConnectionRequest> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterMessageProtocol.MODEL_COLLECTION;
	}

    public static ClusterConnectionRequest remap(Message message) {
        return new ClusterConnectionRequest(message, ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "cluster.clusterConnectionRequest";


	public ClusterConnectionRequest() {
		super(ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public ClusterConnectionRequest(Message message, ModelCollection modelCollection) {
		super(message, modelCollection);
	}

	public ClusterConnectionRequest(DataInputStream dis) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterConnectionRequest(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterConnectionRequest(byte[] bytes) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterConnectionRequest(byte[] bytes, FileDataReader fileDataReader) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterConnectionRequest(Element element, FileDataReader fileDataReader) {
		super(element, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

    public ClusterConnectionRequest(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
    }

	public ClusterNodeData getLocalNode() {
		return getReferencedObjectAsType("localNode");
	}

	public ClusterConnectionRequest setLocalNode(ClusterNodeData value) {
		setReferencedObjectAsType("localNode", value);
		return this;
	}

	public String[] getLocalServices() {
		return getStringArrayAttribute("localServices");
	}

	public ClusterConnectionRequest setLocalServices(String[] value) {
		setStringArrayAttribute("localServices", value);
		return this;
	}

	public ClusterNodeData getLeaderNode() {
		return getReferencedObjectAsType("leaderNode");
	}

	public ClusterConnectionRequest setLeaderNode(ClusterNodeData value) {
		setReferencedObjectAsType("leaderNode", value);
		return this;
	}

	public List<ClusterNodeData> getKnownPeers() {
		return getReferencedObjectsAsType("knownPeers");
	}

	public ClusterConnectionRequest setKnownPeers(List<ClusterNodeData> value) {
		setReferencedObjectsAsType("knownPeers", value);
		return this;
	}

	public ClusterConnectionRequest addKnownPeers(ClusterNodeData value) {
		addReference("knownPeers", value);
		return this;
	}



}