package org.teamapps.cluster.message.protocol;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.*;
import java.time.*;



public class ClusterInfo extends Message {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<ClusterInfo> decoder = new PojoObjectDecoder<ClusterInfo>() {
		@Override
		public ClusterInfo decode(DataInputStream dis, FileDataReader fileDataReader) {
			try {
				return new ClusterInfo(dis, fileDataReader);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterInfo instance", e);
			}
			return null;
		}

		@Override
		public ClusterInfo decode(Element element, FileDataReader fileDataReader) {
			return new ClusterInfo(element, fileDataReader);
		}

        @Override
        public ClusterInfo decode(String xml, FileDataReader fileDataReader) {
            try {
                return new ClusterInfo(xml, fileDataReader);
            } catch (Exception e) {
                LOGGER.error("Error creating ClusterInfo instance", e);
            }
            return null;
        }

		@Override
		public ClusterInfo defaultMessage() {
			return (ClusterInfo) new ClusterInfo().setDefaultValues();
		}

		@Override
		public ClusterInfo remap(Message message) {
			return new ClusterInfo(message, ClusterMessageProtocol.MODEL_COLLECTION);
		}

        @Override
        public String getMessageUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<ClusterInfo> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterMessageProtocol.MODEL_COLLECTION;
	}

    public static ClusterInfo remap(Message message) {
        return new ClusterInfo(message, ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "cluster.clusterInfo";


	public ClusterInfo() {
		super(ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public ClusterInfo(Message message, ModelCollection modelCollection) {
		super(message, modelCollection);
	}

	public ClusterInfo(DataInputStream dis) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterInfo(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterInfo(byte[] bytes) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterInfo(byte[] bytes, FileDataReader fileDataReader) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterInfo(Element element, FileDataReader fileDataReader) {
		super(element, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

    public ClusterInfo(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
    }

	public ClusterNodeData getLocalNode() {
		return getReferencedObjectAsType("localNode");
	}

	public ClusterInfo setLocalNode(ClusterNodeData value) {
		setReferencedObjectAsType("localNode", value);
		return this;
	}

	public List<ClusterNodeData> getPeerNodes() {
		return getReferencedObjectsAsType("peerNodes");
	}

	public ClusterInfo setPeerNodes(List<ClusterNodeData> value) {
		setReferencedObjectsAsType("peerNodes", value);
		return this;
	}

	public ClusterInfo addPeerNodes(ClusterNodeData value) {
		addReference("peerNodes", value);
		return this;
	}



}