package org.teamapps.cluster.message.protocol;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.*;
import java.time.*;



public class ClusterMessageFilePart extends Message {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<ClusterMessageFilePart> decoder = new PojoObjectDecoder<ClusterMessageFilePart>() {
		@Override
		public ClusterMessageFilePart decode(DataInputStream dis, FileDataReader fileDataReader) {
			try {
				return new ClusterMessageFilePart(dis, fileDataReader);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterMessageFilePart instance", e);
			}
			return null;
		}

		@Override
		public ClusterMessageFilePart decode(Element element, FileDataReader fileDataReader) {
			return new ClusterMessageFilePart(element, fileDataReader);
		}

        @Override
        public ClusterMessageFilePart decode(String xml, FileDataReader fileDataReader) {
            try {
                return new ClusterMessageFilePart(xml, fileDataReader);
            } catch (Exception e) {
                LOGGER.error("Error creating ClusterMessageFilePart instance", e);
            }
            return null;
        }

		@Override
		public ClusterMessageFilePart defaultMessage() {
			return (ClusterMessageFilePart) new ClusterMessageFilePart().setDefaultValues();
		}

		@Override
		public ClusterMessageFilePart remap(Message message) {
			return new ClusterMessageFilePart(message, ClusterMessageProtocol.MODEL_COLLECTION);
		}

        @Override
        public String getMessageUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<ClusterMessageFilePart> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterMessageProtocol.MODEL_COLLECTION;
	}

    public static ClusterMessageFilePart remap(Message message) {
        return new ClusterMessageFilePart(message, ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "cluster.clusterMessageFilePart";


	public ClusterMessageFilePart() {
		super(ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public ClusterMessageFilePart(Message message, ModelCollection modelCollection) {
		super(message, modelCollection);
	}

	public ClusterMessageFilePart(DataInputStream dis) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterMessageFilePart(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterMessageFilePart(byte[] bytes) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterMessageFilePart(byte[] bytes, FileDataReader fileDataReader) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterMessageFilePart(Element element, FileDataReader fileDataReader) {
		super(element, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

    public ClusterMessageFilePart(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
    }

	public String getFileId() {
		return getStringAttribute("fileId");
	}

	public ClusterMessageFilePart setFileId(String value) {
		setStringAttribute("fileId", value);
		return this;
	}

	public long getTotalLength() {
		return getLongAttribute("totalLength");
	}

	public ClusterMessageFilePart setTotalLength(long value) {
		setLongAttribute("totalLength", value);
		return this;
	}

	public boolean isInitialMessage() {
		return getBooleanAttribute("initialMessage");
	}

	public ClusterMessageFilePart setInitialMessage(boolean value) {
		setBooleanAttribute("initialMessage", value);
		return this;
	}

	public boolean isLastMessage() {
		return getBooleanAttribute("lastMessage");
	}

	public ClusterMessageFilePart setLastMessage(boolean value) {
		setBooleanAttribute("lastMessage", value);
		return this;
	}

	public byte[] getData() {
		return getByteArrayAttribute("data");
	}

	public ClusterMessageFilePart setData(byte[] value) {
		setByteArrayAttribute("data", value);
		return this;
	}



}