package org.teamapps.cluster.message.protocol;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.*;
import java.time.*;



public class ClusterNodeData extends Message {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<ClusterNodeData> decoder = new PojoObjectDecoder<ClusterNodeData>() {
		@Override
		public ClusterNodeData decode(DataInputStream dis, FileDataReader fileDataReader) {
			try {
				return new ClusterNodeData(dis, fileDataReader);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterNodeData instance", e);
			}
			return null;
		}

		@Override
		public ClusterNodeData decode(Element element, FileDataReader fileDataReader) {
			return new ClusterNodeData(element, fileDataReader);
		}

        @Override
        public ClusterNodeData decode(String xml, FileDataReader fileDataReader) {
            try {
                return new ClusterNodeData(xml, fileDataReader);
            } catch (Exception e) {
                LOGGER.error("Error creating ClusterNodeData instance", e);
            }
            return null;
        }

		@Override
		public ClusterNodeData defaultMessage() {
			return (ClusterNodeData) new ClusterNodeData().setDefaultValues();
		}

		@Override
		public ClusterNodeData remap(Message message) {
			return new ClusterNodeData(message, ClusterMessageProtocol.MODEL_COLLECTION);
		}

        @Override
        public String getMessageUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<ClusterNodeData> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterMessageProtocol.MODEL_COLLECTION;
	}

    public static ClusterNodeData remap(Message message) {
        return new ClusterNodeData(message, ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "cluster.clusterNodeData";


	public ClusterNodeData() {
		super(ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public ClusterNodeData(Message message, ModelCollection modelCollection) {
		super(message, modelCollection);
	}

	public ClusterNodeData(DataInputStream dis) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNodeData(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNodeData(byte[] bytes) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNodeData(byte[] bytes, FileDataReader fileDataReader) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNodeData(Element element, FileDataReader fileDataReader) {
		super(element, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

    public ClusterNodeData(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
    }

	public String getNodeId() {
		return getStringAttribute("nodeId");
	}

	public ClusterNodeData setNodeId(String value) {
		setStringAttribute("nodeId", value);
		return this;
	}

	public String getHost() {
		return getStringAttribute("host");
	}

	public ClusterNodeData setHost(String value) {
		setStringAttribute("host", value);
		return this;
	}

	public int getPort() {
		return getIntAttribute("port");
	}

	public ClusterNodeData setPort(int value) {
		setIntAttribute("port", value);
		return this;
	}

	public boolean isLeaderNode() {
		return getBooleanAttribute("leaderNode");
	}

	public ClusterNodeData setLeaderNode(boolean value) {
		setBooleanAttribute("leaderNode", value);
		return this;
	}



}