package org.teamapps.cluster.message.protocol;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.*;
import java.time.*;



public class ClusterNodeShutDownInfo extends Message {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<ClusterNodeShutDownInfo> decoder = new PojoObjectDecoder<ClusterNodeShutDownInfo>() {
		@Override
		public ClusterNodeShutDownInfo decode(DataInputStream dis, FileDataReader fileDataReader) {
			try {
				return new ClusterNodeShutDownInfo(dis, fileDataReader);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterNodeShutDownInfo instance", e);
			}
			return null;
		}

		@Override
		public ClusterNodeShutDownInfo decode(Element element, FileDataReader fileDataReader) {
			return new ClusterNodeShutDownInfo(element, fileDataReader);
		}

        @Override
        public ClusterNodeShutDownInfo decode(String xml, FileDataReader fileDataReader) {
            try {
                return new ClusterNodeShutDownInfo(xml, fileDataReader);
            } catch (Exception e) {
                LOGGER.error("Error creating ClusterNodeShutDownInfo instance", e);
            }
            return null;
        }

		@Override
		public ClusterNodeShutDownInfo defaultMessage() {
			return (ClusterNodeShutDownInfo) new ClusterNodeShutDownInfo().setDefaultValues();
		}

		@Override
		public ClusterNodeShutDownInfo remap(Message message) {
			return new ClusterNodeShutDownInfo(message, ClusterMessageProtocol.MODEL_COLLECTION);
		}

        @Override
        public String getMessageUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<ClusterNodeShutDownInfo> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterMessageProtocol.MODEL_COLLECTION;
	}

    public static ClusterNodeShutDownInfo remap(Message message) {
        return new ClusterNodeShutDownInfo(message, ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "cluster.clusterNodeShutDownInfo";


	public ClusterNodeShutDownInfo() {
		super(ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public ClusterNodeShutDownInfo(Message message, ModelCollection modelCollection) {
		super(message, modelCollection);
	}

	public ClusterNodeShutDownInfo(DataInputStream dis) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNodeShutDownInfo(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNodeShutDownInfo(byte[] bytes) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNodeShutDownInfo(byte[] bytes, FileDataReader fileDataReader) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNodeShutDownInfo(Element element, FileDataReader fileDataReader) {
		super(element, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

    public ClusterNodeShutDownInfo(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
    }



}