package org.teamapps.cluster.message.protocol;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.*;
import java.time.*;



public class ClusterNodeSystemInfo extends Message {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<ClusterNodeSystemInfo> decoder = new PojoObjectDecoder<ClusterNodeSystemInfo>() {
		@Override
		public ClusterNodeSystemInfo decode(DataInputStream dis, FileDataReader fileDataReader) {
			try {
				return new ClusterNodeSystemInfo(dis, fileDataReader);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterNodeSystemInfo instance", e);
			}
			return null;
		}

		@Override
		public ClusterNodeSystemInfo decode(Element element, FileDataReader fileDataReader) {
			return new ClusterNodeSystemInfo(element, fileDataReader);
		}

        @Override
        public ClusterNodeSystemInfo decode(String xml, FileDataReader fileDataReader) {
            try {
                return new ClusterNodeSystemInfo(xml, fileDataReader);
            } catch (Exception e) {
                LOGGER.error("Error creating ClusterNodeSystemInfo instance", e);
            }
            return null;
        }

		@Override
		public ClusterNodeSystemInfo defaultMessage() {
			return (ClusterNodeSystemInfo) new ClusterNodeSystemInfo().setDefaultValues();
		}

		@Override
		public ClusterNodeSystemInfo remap(Message message) {
			return new ClusterNodeSystemInfo(message, ClusterMessageProtocol.MODEL_COLLECTION);
		}

        @Override
        public String getMessageUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<ClusterNodeSystemInfo> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterMessageProtocol.MODEL_COLLECTION;
	}

    public static ClusterNodeSystemInfo remap(Message message) {
        return new ClusterNodeSystemInfo(message, ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "cluster.clusterNodeSystemInfo";


	public ClusterNodeSystemInfo() {
		super(ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public ClusterNodeSystemInfo(Message message, ModelCollection modelCollection) {
		super(message, modelCollection);
	}

	public ClusterNodeSystemInfo(DataInputStream dis) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNodeSystemInfo(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNodeSystemInfo(byte[] bytes) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNodeSystemInfo(byte[] bytes, FileDataReader fileDataReader) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNodeSystemInfo(Element element, FileDataReader fileDataReader) {
		super(element, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

    public ClusterNodeSystemInfo(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
    }

	public String getDetailedInfo() {
		return getStringAttribute("detailedInfo");
	}

	public ClusterNodeSystemInfo setDetailedInfo(String value) {
		setStringAttribute("detailedInfo", value);
		return this;
	}

	public int getCpus() {
		return getIntAttribute("cpus");
	}

	public ClusterNodeSystemInfo setCpus(int value) {
		setIntAttribute("cpus", value);
		return this;
	}

	public int getCores() {
		return getIntAttribute("cores");
	}

	public ClusterNodeSystemInfo setCores(int value) {
		setIntAttribute("cores", value);
		return this;
	}

	public int getThreads() {
		return getIntAttribute("threads");
	}

	public ClusterNodeSystemInfo setThreads(int value) {
		setIntAttribute("threads", value);
		return this;
	}

	public long getMemorySize() {
		return getLongAttribute("memorySize");
	}

	public ClusterNodeSystemInfo setMemorySize(long value) {
		setLongAttribute("memorySize", value);
		return this;
	}



}