package org.teamapps.cluster.message.protocol;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.*;
import java.time.*;



public class ClusterServiceMethodRequest extends Message {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<ClusterServiceMethodRequest> decoder = new PojoObjectDecoder<ClusterServiceMethodRequest>() {
		@Override
		public ClusterServiceMethodRequest decode(DataInputStream dis, FileDataReader fileDataReader) {
			try {
				return new ClusterServiceMethodRequest(dis, fileDataReader);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterServiceMethodRequest instance", e);
			}
			return null;
		}

		@Override
		public ClusterServiceMethodRequest decode(Element element, FileDataReader fileDataReader) {
			return new ClusterServiceMethodRequest(element, fileDataReader);
		}

        @Override
        public ClusterServiceMethodRequest decode(String xml, FileDataReader fileDataReader) {
            try {
                return new ClusterServiceMethodRequest(xml, fileDataReader);
            } catch (Exception e) {
                LOGGER.error("Error creating ClusterServiceMethodRequest instance", e);
            }
            return null;
        }

		@Override
		public ClusterServiceMethodRequest defaultMessage() {
			return (ClusterServiceMethodRequest) new ClusterServiceMethodRequest().setDefaultValues();
		}

		@Override
		public ClusterServiceMethodRequest remap(Message message) {
			return new ClusterServiceMethodRequest(message, ClusterMessageProtocol.MODEL_COLLECTION);
		}

        @Override
        public String getMessageUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<ClusterServiceMethodRequest> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterMessageProtocol.MODEL_COLLECTION;
	}

    public static ClusterServiceMethodRequest remap(Message message) {
        return new ClusterServiceMethodRequest(message, ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "cluster.clusterServiceMethodRequest";


	public ClusterServiceMethodRequest() {
		super(ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public ClusterServiceMethodRequest(Message message, ModelCollection modelCollection) {
		super(message, modelCollection);
	}

	public ClusterServiceMethodRequest(DataInputStream dis) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterServiceMethodRequest(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterServiceMethodRequest(byte[] bytes) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterServiceMethodRequest(byte[] bytes, FileDataReader fileDataReader) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterServiceMethodRequest(Element element, FileDataReader fileDataReader) {
		super(element, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

    public ClusterServiceMethodRequest(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
    }

	public long getClusterTaskId() {
		return getLongAttribute("clusterTaskId");
	}

	public ClusterServiceMethodRequest setClusterTaskId(long value) {
		setLongAttribute("clusterTaskId", value);
		return this;
	}

	public String getServiceName() {
		return getStringAttribute("serviceName");
	}

	public ClusterServiceMethodRequest setServiceName(String value) {
		setStringAttribute("serviceName", value);
		return this;
	}

	public String getMethodName() {
		return getStringAttribute("methodName");
	}

	public ClusterServiceMethodRequest setMethodName(String value) {
		setStringAttribute("methodName", value);
		return this;
	}

	public Message getRequestMessage() {
		return getGenericMessageAttribute("requestMessage");
	}

	public ClusterServiceMethodRequest setRequestMessage(Message value) {
		setGenericMessageAttribute("requestMessage", value);
		return this;
	}



}