package org.teamapps.cluster.message.protocol;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.*;
import java.time.*;



public class ClusterServiceMethodResult extends Message {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<ClusterServiceMethodResult> decoder = new PojoObjectDecoder<ClusterServiceMethodResult>() {
		@Override
		public ClusterServiceMethodResult decode(DataInputStream dis, FileDataReader fileDataReader) {
			try {
				return new ClusterServiceMethodResult(dis, fileDataReader);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterServiceMethodResult instance", e);
			}
			return null;
		}

		@Override
		public ClusterServiceMethodResult decode(Element element, FileDataReader fileDataReader) {
			return new ClusterServiceMethodResult(element, fileDataReader);
		}

        @Override
        public ClusterServiceMethodResult decode(String xml, FileDataReader fileDataReader) {
            try {
                return new ClusterServiceMethodResult(xml, fileDataReader);
            } catch (Exception e) {
                LOGGER.error("Error creating ClusterServiceMethodResult instance", e);
            }
            return null;
        }

		@Override
		public ClusterServiceMethodResult defaultMessage() {
			return (ClusterServiceMethodResult) new ClusterServiceMethodResult().setDefaultValues();
		}

		@Override
		public ClusterServiceMethodResult remap(Message message) {
			return new ClusterServiceMethodResult(message, ClusterMessageProtocol.MODEL_COLLECTION);
		}

        @Override
        public String getMessageUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<ClusterServiceMethodResult> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterMessageProtocol.MODEL_COLLECTION;
	}

    public static ClusterServiceMethodResult remap(Message message) {
        return new ClusterServiceMethodResult(message, ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "cluster.clusterServiceMethodResult";


	public ClusterServiceMethodResult() {
		super(ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public ClusterServiceMethodResult(Message message, ModelCollection modelCollection) {
		super(message, modelCollection);
	}

	public ClusterServiceMethodResult(DataInputStream dis) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterServiceMethodResult(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterServiceMethodResult(byte[] bytes) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterServiceMethodResult(byte[] bytes, FileDataReader fileDataReader) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterServiceMethodResult(Element element, FileDataReader fileDataReader) {
		super(element, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

    public ClusterServiceMethodResult(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
    }

	public long getClusterTaskId() {
		return getLongAttribute("clusterTaskId");
	}

	public ClusterServiceMethodResult setClusterTaskId(long value) {
		setLongAttribute("clusterTaskId", value);
		return this;
	}

	public String getServiceName() {
		return getStringAttribute("serviceName");
	}

	public ClusterServiceMethodResult setServiceName(String value) {
		setStringAttribute("serviceName", value);
		return this;
	}

	public String getMethodName() {
		return getStringAttribute("methodName");
	}

	public ClusterServiceMethodResult setMethodName(String value) {
		setStringAttribute("methodName", value);
		return this;
	}

	public Message getResultMessage() {
		return getGenericMessageAttribute("resultMessage");
	}

	public ClusterServiceMethodResult setResultMessage(Message value) {
		setGenericMessageAttribute("resultMessage", value);
		return this;
	}

	public boolean isError() {
		return getBooleanAttribute("error");
	}

	public ClusterServiceMethodResult setError(boolean value) {
		setBooleanAttribute("error", value);
		return this;
	}

	public ClusterServiceMethodErrorType getErrorType() {
		int id = getIntAttribute("errorType");
		return id > 0 ? ClusterServiceMethodErrorType.values()[id - 1] : null;
	}

	public ClusterServiceMethodResult setErrorType(ClusterServiceMethodErrorType value) {
		setIntAttribute("errorType", value != null ? value.getId() : null);
		return this;
	}

	public String getErrorMessage() {
		return getStringAttribute("errorMessage");
	}

	public ClusterServiceMethodResult setErrorMessage(String value) {
		setStringAttribute("errorMessage", value);
		return this;
	}

	public String getErrorStackTrace() {
		return getStringAttribute("errorStackTrace");
	}

	public ClusterServiceMethodResult setErrorStackTrace(String value) {
		setStringAttribute("errorStackTrace", value);
		return this;
	}



}