/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.message.protocol;

import java.io.DataInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.cluster.message.protocol.ClusterMessageProtocol;
import org.teamapps.cluster.message.protocol.ClusterNodeData;
import org.teamapps.message.protocol.file.FileDataReader;
import org.teamapps.message.protocol.message.Message;
import org.teamapps.message.protocol.model.MessageModel;
import org.teamapps.message.protocol.model.ModelCollection;
import org.teamapps.message.protocol.model.PojoObjectDecoder;
import org.teamapps.message.protocol.model.PojoObjectDecoderRegistry;
import org.w3c.dom.Element;

public class ClusterConfig
extends Message {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PojoObjectDecoder<ClusterConfig> decoder = new PojoObjectDecoder<ClusterConfig>(){

        public ClusterConfig decode(DataInputStream dis, FileDataReader fileDataReader) {
            try {
                return new ClusterConfig(dis, fileDataReader);
            }
            catch (IOException e) {
                LOGGER.error("Error creating ClusterConfig instance", (Throwable)e);
                return null;
            }
        }

        public ClusterConfig decode(Element element, FileDataReader fileDataReader) {
            return new ClusterConfig(element, fileDataReader);
        }

        public ClusterConfig decode(String xml, FileDataReader fileDataReader) {
            try {
                return new ClusterConfig(xml, fileDataReader);
            }
            catch (Exception e) {
                LOGGER.error("Error creating ClusterConfig instance", (Throwable)e);
                return null;
            }
        }

        public ClusterConfig defaultMessage() {
            return (ClusterConfig)new ClusterConfig().setDefaultValues();
        }

        public ClusterConfig remap(Message message) {
            return new ClusterConfig(message, (ModelCollection)ClusterMessageProtocol.MODEL_COLLECTION);
        }

        public String getMessageUuid() {
            return ClusterConfig.OBJECT_UUID;
        }
    };
    public static final String OBJECT_UUID = "cluster.clusterConfig";

    public static PojoObjectDecoder<ClusterConfig> getMessageDecoder() {
        return decoder;
    }

    public static MessageModel getMessageModel() {
        return ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

    public static ModelCollection getModelCollection() {
        return ClusterMessageProtocol.MODEL_COLLECTION;
    }

    public static ClusterConfig remap(Message message) {
        return new ClusterConfig(message, (ModelCollection)ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public ClusterConfig() {
        super(ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
    }

    public ClusterConfig(Message message, ModelCollection modelCollection) {
        super(message, modelCollection);
    }

    public ClusterConfig(DataInputStream dis) throws IOException {
        super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, (PojoObjectDecoderRegistry)ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public ClusterConfig(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
        super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, (PojoObjectDecoderRegistry)ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public ClusterConfig(byte[] bytes) throws IOException {
        super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, (PojoObjectDecoderRegistry)ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public ClusterConfig(byte[] bytes, FileDataReader fileDataReader) throws IOException {
        super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, (PojoObjectDecoderRegistry)ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public ClusterConfig(Element element, FileDataReader fileDataReader) {
        super(element, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, (PojoObjectDecoderRegistry)ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public ClusterConfig(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, (PojoObjectDecoderRegistry)ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public String getClusterSecret() {
        return this.getStringAttribute("clusterSecret");
    }

    public ClusterConfig setClusterSecret(String value) {
        this.setStringAttribute("clusterSecret", value);
        return this;
    }

    public String getNodeId() {
        return this.getStringAttribute("nodeId");
    }

    public ClusterConfig setNodeId(String value) {
        this.setStringAttribute("nodeId", value);
        return this;
    }

    public String getHost() {
        return this.getStringAttribute("host");
    }

    public ClusterConfig setHost(String value) {
        this.setStringAttribute("host", value);
        return this;
    }

    public int getPort() {
        return this.getIntAttribute("port");
    }

    public ClusterConfig setPort(int value) {
        this.setIntAttribute("port", value);
        return this;
    }

    public boolean isLeaderNode() {
        return this.getBooleanAttribute("leaderNode");
    }

    public ClusterConfig setLeaderNode(boolean value) {
        this.setBooleanAttribute("leaderNode", value);
        return this;
    }

    public List<ClusterNodeData> getPeerNodes() {
        return this.getReferencedObjectsAsType("peerNodes");
    }

    public ClusterConfig setPeerNodes(List<ClusterNodeData> value) {
        this.setReferencedObjectsAsType("peerNodes", value);
        return this;
    }

    public ClusterConfig addPeerNodes(ClusterNodeData value) {
        this.addReference("peerNodes", value);
        return this;
    }
}

