/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.state;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.teamapps.cluster.state.ChangeOperation;
import org.teamapps.message.protocol.file.FileDataReader;
import org.teamapps.message.protocol.file.FileDataWriter;
import org.teamapps.message.protocol.message.Message;
import org.teamapps.message.protocol.model.ModelRegistry;
import org.teamapps.message.protocol.utils.MessageUtils;

public class StateUpdateMessage {
    private final String subStateId;
    private final ChangeOperation operation;
    private final String identifier;
    private final Message message;

    public StateUpdateMessage(String subStateId, ChangeOperation operation, String identifier, Message message) {
        this.subStateId = subStateId;
        this.operation = operation;
        this.identifier = identifier;
        this.message = message;
    }

    public StateUpdateMessage(DataInputStream dis, ModelRegistry modelRegistry, FileDataReader fileDataReader) throws IOException {
        this.subStateId = MessageUtils.readString((DataInputStream)dis);
        this.operation = ChangeOperation.getById(dis.readUnsignedByte());
        this.identifier = MessageUtils.readString((DataInputStream)dis);
        this.message = new Message(dis, modelRegistry, fileDataReader, null);
    }

    public String getSubStateId() {
        return this.subStateId;
    }

    public ChangeOperation getOperation() {
        return this.operation;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Message getMessage() {
        return this.message;
    }

    public void write(DataOutputStream dos, FileDataWriter fileDataWriter) throws IOException {
        MessageUtils.writeString((DataOutputStream)dos, (String)this.subStateId);
        dos.writeByte(this.operation.getId());
        MessageUtils.writeString((DataOutputStream)dos, (String)this.identifier);
        this.message.write(dos, fileDataWriter);
    }

    public byte[] toBytes(FileDataWriter fileDataWriter) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos, fileDataWriter);
        dos.flush();
        return bos.toByteArray();
    }
}

