/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.core;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.cluster.core.Cluster;
import org.teamapps.cluster.core.ClusterConnection;
import org.teamapps.cluster.message.protocol.ClusterNodeData;
import org.teamapps.message.protocol.message.Message;

public class ClusterNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Cluster cluster;
    private final ClusterNodeData nodeData;
    private volatile ClusterConnection connection;
    private volatile int activeTasks;
    private long sentBytes;
    private long receivedBytes;
    private long sentMessages;
    private long receivedMessages;

    public ClusterNode(Cluster cluster, ClusterNodeData nodeData, ClusterConnection connection) {
        this.cluster = cluster;
        this.nodeData = nodeData;
        this.connection = connection;
        connection.setClusterNode(this);
        this.init();
        LOGGER.info("Cluster node [{}]: new peer node: {} [{}:{}]", new Object[]{cluster.getLocalNode().getNodeId(), nodeData.getNodeId(), nodeData.getHost(), nodeData.getPort()});
    }

    private void init() {
        this.cluster.getScheduledExecutorService().scheduleWithFixedDelay(() -> {
            if (this.isConnected()) {
                // empty if block
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        this.cluster.getScheduledExecutorService().scheduleWithFixedDelay(() -> {
            if (!this.isConnected()) {
                this.cluster.connectNode(this.nodeData);
            } else {
                this.cluster.sendLoadInfoMessage();
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }

    public synchronized void writeMessage(Message message) {
        if (this.isConnected()) {
            this.connection.writeMessage(message);
        }
    }

    public void handleConnectionUpdate(ClusterConnection connection) {
        this.connection = connection;
        connection.setClusterNode(this);
        LOGGER.info("Cluster node [{}]: peer node reconnected: {} [{}:{}]", new Object[]{this.cluster.getLocalNode().getNodeId(), this.nodeData.getNodeId(), this.nodeData.getHost(), this.nodeData.getPort()});
    }

    public synchronized void handleConnectionClosed() {
        if (this.connection != null) {
            this.receivedBytes += this.connection.getReceivedBytes();
            this.sentBytes += this.connection.getSentBytes();
            this.receivedMessages += this.connection.getReceivedMessages();
            this.sentMessages += this.connection.getSentMessages();
        }
        this.connection = null;
        LOGGER.info("Cluster node [{}]: peer node disconnected: {} [{}:{}]", new Object[]{this.cluster.getLocalNode().getNodeId(), this.nodeData.getNodeId(), this.nodeData.getHost(), this.nodeData.getPort()});
        this.cluster.handleDisconnect(this);
        Runnable reconnect = () -> {
            if (!this.cluster.isConnected(this.nodeData)) {
                this.cluster.connectNode(this.nodeData);
            }
        };
        if (this.nodeData.getPort() > 0 && this.nodeData.getHost() != null && !this.cluster.getScheduledExecutorService().isShutdown()) {
            this.cluster.getScheduledExecutorService().schedule(reconnect, 100L, TimeUnit.MILLISECONDS);
            this.cluster.getScheduledExecutorService().schedule(reconnect, 1L, TimeUnit.SECONDS);
            this.cluster.getScheduledExecutorService().schedule(reconnect, 3L, TimeUnit.SECONDS);
            this.cluster.getScheduledExecutorService().schedule(reconnect, 15L, TimeUnit.SECONDS);
        }
    }

    public ClusterNodeData getNodeData() {
        return this.nodeData;
    }

    public ClusterConnection getConnection() {
        return this.connection;
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    public void closeConnection() {
        if (this.isConnected()) {
            this.connection.close();
        }
    }

    public int getActiveTasks() {
        return this.activeTasks;
    }

    public void setActiveTasks(int activeTasks) {
        this.activeTasks = activeTasks;
    }

    public void addTask() {
        ++this.activeTasks;
    }

    public long getSentBytes() {
        return this.connection != null ? this.connection.getSentBytes() + this.sentBytes : this.sentBytes;
    }

    public long getReceivedBytes() {
        return this.connection != null ? this.connection.getReceivedBytes() + this.receivedBytes : this.receivedBytes;
    }

    public long getSentMessages() {
        return this.connection != null ? this.connection.getSentMessages() + this.sentMessages : this.sentMessages;
    }

    public long getReceivedMessages() {
        return this.connection != null ? this.connection.getReceivedMessages() + this.receivedMessages : this.receivedMessages;
    }
}

