/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.utils;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.cluster.message.protocol.ClusterNodeSystemInfo;
import org.teamapps.commons.formatter.FileSizeFormatter;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;

public class SystemInfoUtil {
    public static ClusterNodeSystemInfo createNodeInfo() {
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hardware = si.getHardware();
        CentralProcessor processor = hardware.getProcessor();
        return new ClusterNodeSystemInfo().setDetailedInfo(SystemInfoUtil.getSystemInfoMessage()).setCpus(processor.getPhysicalPackageCount()).setCores(processor.getPhysicalProcessorCount()).setThreads(processor.getLogicalProcessorCount()).setMemorySize(hardware.getMemory().getTotal());
    }

    public static String getSystemInfoMessage() {
        StringBuilder sb = new StringBuilder();
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hardware = si.getHardware();
        OperatingSystem operatingSystem = si.getOperatingSystem();
        CentralProcessor processor = hardware.getProcessor();
        SystemInfoUtil.addLine(sb, 0, "Processor", null);
        SystemInfoUtil.addLine(sb, 1, "Identifier", processor.getProcessorIdentifier());
        SystemInfoUtil.addLine(sb, 1, "Processor-ID", processor.getProcessorIdentifier().getProcessorID());
        SystemInfoUtil.addLine(sb, 1, "CPUs", processor.getPhysicalPackageCount());
        SystemInfoUtil.addLine(sb, 1, "Cores", processor.getPhysicalProcessorCount());
        SystemInfoUtil.addLine(sb, 1, "Threads", processor.getLogicalProcessorCount());
        GlobalMemory memory = hardware.getMemory();
        SystemInfoUtil.addLine(sb, 0, "Memory", null);
        SystemInfoUtil.addLine(sb, 1, "Total", FileSizeFormatter.humanReadableByteCount((long)memory.getTotal(), (boolean)false, (int)1));
        SystemInfoUtil.addLine(sb, 1, "Available", FileSizeFormatter.humanReadableByteCount((long)memory.getAvailable(), (boolean)false, (int)1));
        ComputerSystem computerSystem = hardware.getComputerSystem();
        SystemInfoUtil.addLine(sb, 0, "System", null);
        SystemInfoUtil.addLine(sb, 1, "Manufacturer", computerSystem.getManufacturer());
        SystemInfoUtil.addLine(sb, 1, "Hardware-ID", computerSystem.getHardwareUUID());
        SystemInfoUtil.addLine(sb, 1, "Serial-No", computerSystem.getSerialNumber());
        SystemInfoUtil.addLine(sb, 1, "Firmware", computerSystem.getFirmware());
        List networkIFs = hardware.getNetworkIFs();
        SystemInfoUtil.addLine(sb, 0, "Network", null);
        for (int i = 0; i < networkIFs.size(); ++i) {
            NetworkIF networkIF = (NetworkIF)networkIFs.get(i);
            SystemInfoUtil.addLine(sb, 1, "Network card " + (i + 1), null);
            SystemInfoUtil.addLine(sb, 2, "Name", networkIF.getName());
            SystemInfoUtil.addLine(sb, 2, "Display name", networkIF.getDisplayName());
            SystemInfoUtil.addLine(sb, 2, "IPv4", networkIF.getIPv4addr());
            SystemInfoUtil.addLine(sb, 2, "IPv6", networkIF.getIPv6addr());
            SystemInfoUtil.addLine(sb, 2, "Mac", networkIF.getMacaddr());
        }
        List diskStores = hardware.getDiskStores();
        SystemInfoUtil.addLine(sb, 0, "Storage", null);
        for (int i = 0; i < diskStores.size(); ++i) {
            HWDiskStore store = (HWDiskStore)diskStores.get(i);
            SystemInfoUtil.addLine(sb, 1, "Hard disc " + (i + 1), null);
            SystemInfoUtil.addLine(sb, 2, "Size", FileSizeFormatter.humanReadableByteCount((long)store.getSize(), (boolean)false, (int)1));
            SystemInfoUtil.addLine(sb, 2, "Model", store.getModel());
            SystemInfoUtil.addLine(sb, 2, "Name", store.getName());
            SystemInfoUtil.addLine(sb, 2, "Serial", store.getSerial());
        }
        OperatingSystem.OSVersionInfo versionInfo = operatingSystem.getVersionInfo();
        SystemInfoUtil.addLine(sb, 0, "OS", null);
        SystemInfoUtil.addLine(sb, 1, "Manufacturer", operatingSystem.getManufacturer());
        SystemInfoUtil.addLine(sb, 1, "Family", operatingSystem.getFamily());
        SystemInfoUtil.addLine(sb, 1, "Version", versionInfo.getVersion());
        SystemInfoUtil.addLine(sb, 1, "Code name", versionInfo.getCodeName());
        SystemInfoUtil.addLine(sb, 1, "Build", versionInfo.getBuildNumber());
        SystemInfoUtil.addLine(sb, 1, "System boot", Instant.ofEpochSecond(operatingSystem.getSystemBootTime()));
        FileSystem fileSystem = operatingSystem.getFileSystem();
        List fileStores = fileSystem.getFileStores();
        SystemInfoUtil.addLine(sb, 0, "File system", null);
        SystemInfoUtil.addLine(sb, 1, "Max file descriptors per process", fileSystem.getMaxFileDescriptorsPerProcess());
        SystemInfoUtil.addLine(sb, 1, "Max file descriptors", fileSystem.getMaxFileDescriptors());
        SystemInfoUtil.addLine(sb, 1, "Open file descriptors", fileSystem.getOpenFileDescriptors());
        for (int i = 0; i < fileStores.size(); ++i) {
            OSFileStore store = (OSFileStore)fileStores.get(i);
            SystemInfoUtil.addLine(sb, 1, "File store " + (i + 1), null);
            SystemInfoUtil.addLine(sb, 2, "Volume", store.getVolume());
            SystemInfoUtil.addLine(sb, 2, "Logical volume", store.getLogicalVolume());
            SystemInfoUtil.addLine(sb, 2, "Mount", store.getMount());
            SystemInfoUtil.addLine(sb, 2, "Label", store.getLabel());
            SystemInfoUtil.addLine(sb, 2, "Description", store.getDescription());
            SystemInfoUtil.addLine(sb, 2, "Total space", FileSizeFormatter.humanReadableByteCount((long)store.getTotalSpace(), (boolean)false, (int)1));
            SystemInfoUtil.addLine(sb, 2, "Free space", FileSizeFormatter.humanReadableByteCount((long)store.getFreeSpace(), (boolean)false, (int)1));
            SystemInfoUtil.addLine(sb, 2, "UUID", store.getUUID());
            SystemInfoUtil.addLine(sb, 2, "Type", store.getType());
        }
        return sb.toString();
    }

    private static void addLine(StringBuilder sb, int tabs, String key, Object value) {
        for (int i = 0; i < tabs; ++i) {
            sb.append("\t");
        }
        sb.append(key).append(": ");
        if (value != null) {
            if (value instanceof String[]) {
                String[] arr = (String[])value;
                sb.append(Arrays.stream(arr).collect(Collectors.joining(", ")));
            } else {
                sb.append(value.toString());
            }
        }
        sb.append("\n");
    }
}

