package org.teamapps.cluster.message.protocol;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import java.io.IOException;

public abstract class AbstractClusterInfoService extends AbstractClusterService {

    public AbstractClusterInfoService() {
        super("clusterInfoService");
    }

    public AbstractClusterInfoService(ClusterServiceRegistry registry) {
        super(registry, "clusterInfoService");
    }

	public abstract ClusterNodeData getHostInfo(ClusterNodeData value);


	@Override
	public Message handleMessage(String method, Message request) {
		return switch (method) {
			case "getHostInfo" -> getHostInfo(ClusterNodeData.remap(request));

			default -> null;
		};
	}

	@Override
	public void handleBroadcastMessage(String method, Message request) {
		switch (method) {

		}
	}
}