package org.teamapps.cluster.message.protocol;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.*;
import java.time.*;



public class ClusterConfig extends Message {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<ClusterConfig> decoder = new PojoObjectDecoder<ClusterConfig>() {
		@Override
		public ClusterConfig decode(DataInputStream dis, FileDataReader fileDataReader) {
			try {
				return new ClusterConfig(dis, fileDataReader);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterConfig instance", e);
			}
			return null;
		}

		@Override
		public ClusterConfig decode(Element element, FileDataReader fileDataReader) {
			return new ClusterConfig(element, fileDataReader);
		}

        @Override
        public ClusterConfig decode(String xml, FileDataReader fileDataReader) {
            try {
                return new ClusterConfig(xml, fileDataReader);
            } catch (Exception e) {
                LOGGER.error("Error creating ClusterConfig instance", e);
            }
            return null;
        }

		@Override
		public ClusterConfig defaultMessage() {
			return (ClusterConfig) new ClusterConfig().setDefaultValues(ClusterMessageProtocol.MODEL_COLLECTION);
		}

		@Override
		public ClusterConfig remap(MessageRecord message) {
			return new ClusterConfig(message, ClusterMessageProtocol.MODEL_COLLECTION);
		}

        @Override
        public String getMessageUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<ClusterConfig> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterMessageProtocol.MODEL_COLLECTION;
	}

    public static ClusterConfig remap(MessageRecord message) {
        return new ClusterConfig(message, ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "cluster.clusterConfig";


	public ClusterConfig() {
		super(ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public ClusterConfig(MessageRecord message, ModelCollection modelCollection) {
		super(message, modelCollection);
	}

	public ClusterConfig(DataInputStream dis) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterConfig(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterConfig(byte[] bytes) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterConfig(byte[] bytes, FileDataReader fileDataReader) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterConfig(Element element, FileDataReader fileDataReader) {
		super(element, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

    public ClusterConfig(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
    }

	public String getClusterSecret() {
		return getStringAttribute("clusterSecret");
	}

	public ClusterConfig setClusterSecret(String value) {
		setStringAttribute("clusterSecret", value);
		return this;
	}

	public String getNodeId() {
		return getStringAttribute("nodeId");
	}

	public ClusterConfig setNodeId(String value) {
		setStringAttribute("nodeId", value);
		return this;
	}

	public String getHost() {
		return getStringAttribute("host");
	}

	public ClusterConfig setHost(String value) {
		setStringAttribute("host", value);
		return this;
	}

	public int getPort() {
		return getIntAttribute("port");
	}

	public ClusterConfig setPort(int value) {
		setIntAttribute("port", value);
		return this;
	}

	public boolean isLeaderNode() {
		return getBooleanAttribute("leaderNode");
	}

	public ClusterConfig setLeaderNode(boolean value) {
		setBooleanAttribute("leaderNode", value);
		return this;
	}

	public List<ClusterNodeData> getPeerNodes() {
		return getReferencedObjectsAsType("peerNodes");
	}

	public ClusterConfig setPeerNodes(List<ClusterNodeData> value) {
		setReferencedObjectsAsType("peerNodes", value);
		return this;
	}

	public ClusterConfig addPeerNodes(ClusterNodeData value) {
		addReference("peerNodes", value);
		return this;
	}



}