package org.teamapps.cluster.message.protocol;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.*;
import java.time.*;



public class ClusterConnectionResult extends Message {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<ClusterConnectionResult> decoder = new PojoObjectDecoder<ClusterConnectionResult>() {
		@Override
		public ClusterConnectionResult decode(DataInputStream dis, FileDataReader fileDataReader) {
			try {
				return new ClusterConnectionResult(dis, fileDataReader);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterConnectionResult instance", e);
			}
			return null;
		}

		@Override
		public ClusterConnectionResult decode(Element element, FileDataReader fileDataReader) {
			return new ClusterConnectionResult(element, fileDataReader);
		}

        @Override
        public ClusterConnectionResult decode(String xml, FileDataReader fileDataReader) {
            try {
                return new ClusterConnectionResult(xml, fileDataReader);
            } catch (Exception e) {
                LOGGER.error("Error creating ClusterConnectionResult instance", e);
            }
            return null;
        }

		@Override
		public ClusterConnectionResult defaultMessage() {
			return (ClusterConnectionResult) new ClusterConnectionResult().setDefaultValues(ClusterMessageProtocol.MODEL_COLLECTION);
		}

		@Override
		public ClusterConnectionResult remap(MessageRecord message) {
			return new ClusterConnectionResult(message, ClusterMessageProtocol.MODEL_COLLECTION);
		}

        @Override
        public String getMessageUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<ClusterConnectionResult> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterMessageProtocol.MODEL_COLLECTION;
	}

    public static ClusterConnectionResult remap(MessageRecord message) {
        return new ClusterConnectionResult(message, ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "cluster.clusterConnectionResult";


	public ClusterConnectionResult() {
		super(ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public ClusterConnectionResult(MessageRecord message, ModelCollection modelCollection) {
		super(message, modelCollection);
	}

	public ClusterConnectionResult(DataInputStream dis) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterConnectionResult(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterConnectionResult(byte[] bytes) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterConnectionResult(byte[] bytes, FileDataReader fileDataReader) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterConnectionResult(Element element, FileDataReader fileDataReader) {
		super(element, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

    public ClusterConnectionResult(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
    }

	public ClusterNodeData getLocalNode() {
		return getReferencedObjectAsType("localNode");
	}

	public ClusterConnectionResult setLocalNode(ClusterNodeData value) {
		setReferencedObjectAsType("localNode", value);
		return this;
	}

	public boolean isAccepted() {
		return getBooleanAttribute("accepted");
	}

	public ClusterConnectionResult setAccepted(boolean value) {
		setBooleanAttribute("accepted", value);
		return this;
	}

	public ClusterNodeData getLeaderNode() {
		return getReferencedObjectAsType("leaderNode");
	}

	public ClusterConnectionResult setLeaderNode(ClusterNodeData value) {
		setReferencedObjectAsType("leaderNode", value);
		return this;
	}

	public List<ClusterNodeData> getKnownPeers() {
		return getReferencedObjectsAsType("knownPeers");
	}

	public ClusterConnectionResult setKnownPeers(List<ClusterNodeData> value) {
		setReferencedObjectsAsType("knownPeers", value);
		return this;
	}

	public ClusterConnectionResult addKnownPeers(ClusterNodeData value) {
		addReference("knownPeers", value);
		return this;
	}

	public String[] getLocalServices() {
		return getStringArrayAttribute("localServices");
	}

	public ClusterConnectionResult setLocalServices(String[] value) {
		setStringArrayAttribute("localServices", value);
		return this;
	}

	public List<String> getLocalServicesAsList() {
		return getStringArrayAsList("localServices");
	}

	public ClusterConnectionResult setLocalServicesAsList(List<String> value) {
		setStringArrayAsList("localServices", value);
		return this;
	}

	public String[] getKnownServices() {
		return getStringArrayAttribute("knownServices");
	}

	public ClusterConnectionResult setKnownServices(String[] value) {
		setStringArrayAttribute("knownServices", value);
		return this;
	}

	public List<String> getKnownServicesAsList() {
		return getStringArrayAsList("knownServices");
	}

	public ClusterConnectionResult setKnownServicesAsList(List<String> value) {
		setStringArrayAsList("knownServices", value);
		return this;
	}



}